/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.wfly10.config.task.subsystem.ejb3;

import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.dmr.ModelNode;
import org.jboss.migration.core.ServerMigrationTask;
import org.jboss.migration.core.ServerMigrationTaskContext;
import org.jboss.migration.core.ServerMigrationTaskName;
import org.jboss.migration.core.ServerMigrationTaskResult;
import org.jboss.migration.core.env.TaskEnvironment;
import org.jboss.migration.wfly10.config.management.ManageableServerConfiguration;
import org.jboss.migration.wfly10.config.management.SubsystemsManagement;
import org.jboss.migration.wfly10.config.task.subsystem.UpdateSubsystemTaskFactory;

public class WorkaroundForWFLY5520
implements UpdateSubsystemTaskFactory.SubtaskFactory {
    public static final WorkaroundForWFLY5520 INSTANCE = new WorkaroundForWFLY5520();
    public static final ServerMigrationTaskName SERVER_MIGRATION_TASK_NAME = new ServerMigrationTaskName.Builder("apply-wfly-5520-fix").build();

    private WorkaroundForWFLY5520() {
    }

    @Override
    public ServerMigrationTask getServerMigrationTask(ModelNode config, UpdateSubsystemTaskFactory subsystem, SubsystemsManagement subsystemsManagement) {
        return new UpdateSubsystemTaskFactory.Subtask(config, subsystem, subsystemsManagement){

            public ServerMigrationTaskName getName() {
                return SERVER_MIGRATION_TASK_NAME;
            }

            @Override
            protected ServerMigrationTaskResult run(ModelNode config, UpdateSubsystemTaskFactory subsystem, SubsystemsManagement subsystemsManagement, ServerMigrationTaskContext context, TaskEnvironment taskEnvironment) throws Exception {
                ManageableServerConfiguration configurationManagement = subsystemsManagement.getServerConfiguration();
                if (!configurationManagement.getServer().getProductInfo().getName().equals("EAP") || !configurationManagement.getServer().getProductInfo().getVersion().equals("7.0.0.Beta1")) {
                    return ServerMigrationTaskResult.SKIPPED;
                }
                if (config == null || !config.hasDefined("default-clustered-sfsb-cache")) {
                    return ServerMigrationTaskResult.SKIPPED;
                }
                PathAddress address = subsystemsManagement.getResourcePathAddress(subsystem.getName());
                ModelNode op = Util.createEmptyOperation((String)"undefine-attribute", (PathAddress)address);
                op.get("name").set("default-clustered-sfsb-cache");
                configurationManagement.executeManagementOperation(op);
                op = Util.createEmptyOperation((String)"write-attribute", (PathAddress)address);
                op.get("name").set("default-sfsb-cache");
                op.get("value").set("clustered");
                configurationManagement.executeManagementOperation(op);
                op = Util.createEmptyOperation((String)"write-attribute", (PathAddress)address);
                op.get("name").set("default-sfsb-passivation-disabled-cache");
                op.get("value").set("simple");
                configurationManagement.executeManagementOperation(op);
                context.getLogger().infof("Target server does not includes fix for WFLY-5520, workaround applied into EJB3 subsystem configuration.", new Object[0]);
                return ServerMigrationTaskResult.SUCCESS;
            }
        };
    }
}

