/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.wfly10.config.task.subsystem.infinispan;

import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.client.helpers.Operations;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.dmr.ModelNode;
import org.jboss.migration.core.ServerMigrationTask;
import org.jboss.migration.core.ServerMigrationTaskContext;
import org.jboss.migration.core.ServerMigrationTaskName;
import org.jboss.migration.core.ServerMigrationTaskResult;
import org.jboss.migration.core.env.TaskEnvironment;
import org.jboss.migration.wfly10.config.management.ManageableServerConfiguration;
import org.jboss.migration.wfly10.config.management.SubsystemsManagement;
import org.jboss.migration.wfly10.config.task.subsystem.UpdateSubsystemTaskFactory;

public class AddEjbCache
implements UpdateSubsystemTaskFactory.SubtaskFactory {
    public static final AddEjbCache INSTANCE = new AddEjbCache();
    public static final ServerMigrationTaskName SERVER_MIGRATION_TASK_NAME = new ServerMigrationTaskName.Builder("add-infinispan-ejb-cache").build();
    private static final String CACHE_CONTAINER = "cache-container";
    private static final String CACHE_NAME = "ejb";
    private static final String ALIASES_ATTR_NAME = "aliases";
    private static final String[] ALIASES_ATTR_VALUE = new String[]{"sfsb"};
    private static final String DEFAULT_CACHE_ATTR_NAME = "default-cache";
    private static final String DEFAULT_CACHE_ATTR_VALUE = "passivation";
    private static final String MODULE_ATTR_NAME = "module";
    private static final String MODULE_ATTR_VALUE = "org.wildfly.clustering.ejb.infinispan";
    private static final String LOCAL_CACHE = "local-cache";
    private static final String LOCAL_CACHE_NAME_PASSIVATION = "passivation";
    private static final String LOCAL_CACHE_NAME_PERSISTENCE = "persistent";
    private static final String COMPONENT = "component";
    private static final String COMPONENT_NAME_TRANSACTION = "transaction";
    private static final String MODE_ATTR_NAME = "mode";
    private static final String MODE_ATTR_VALUE_BATCH = "BATCH";
    private static final String COMPONENT_NAME_LOCKING = "locking";
    private static final String ISOLATION_ATTR_NAME = "isolation";
    private static final String ISOLATION_ATTR_VALUE_REPEATABLE_READ = "REPEATABLE_READ";
    private static final String STORE = "store";
    private static final String STORE_NAME_FILE = "file";
    private static final String PASSIVATION_ATTR_NAME = "passivation";
    private static final String PURGE_ATTR_NAME = "purge";

    private AddEjbCache() {
    }

    @Override
    public ServerMigrationTask getServerMigrationTask(ModelNode config, UpdateSubsystemTaskFactory subsystem, SubsystemsManagement subsystemsManagement) {
        return new UpdateSubsystemTaskFactory.Subtask(config, subsystem, subsystemsManagement){

            public ServerMigrationTaskName getName() {
                return SERVER_MIGRATION_TASK_NAME;
            }

            @Override
            protected ServerMigrationTaskResult run(ModelNode config, UpdateSubsystemTaskFactory subsystem, SubsystemsManagement subsystemsManagement, ServerMigrationTaskContext context, TaskEnvironment taskEnvironment) throws Exception {
                if (config == null) {
                    context.getLogger().debug((Object)"No subsystem config, skipping configuration update.");
                    return ServerMigrationTaskResult.SKIPPED;
                }
                if (!config.hasDefined(AddEjbCache.CACHE_CONTAINER)) {
                    context.getLogger().debug((Object)"No Cache container found in subsystem config, skipping configuration update.");
                    return ServerMigrationTaskResult.SKIPPED;
                }
                if (config.hasDefined(new String[]{AddEjbCache.CACHE_CONTAINER, AddEjbCache.CACHE_NAME})) {
                    context.getLogger().debugf("Cache %s already exists in subsystem config, skipping configuration update.", (Object)AddEjbCache.CACHE_NAME);
                    return ServerMigrationTaskResult.SKIPPED;
                }
                PathAddress subsystemPathAddress = subsystemsManagement.getResourcePathAddress(subsystem.getName());
                ManageableServerConfiguration configurationManagement = subsystemsManagement.getServerConfiguration();
                Operations.CompositeOperationBuilder compositeOperationBuilder = Operations.CompositeOperationBuilder.create();
                PathAddress cachePathAddress = subsystemPathAddress.append(new PathElement[]{PathElement.pathElement((String)AddEjbCache.CACHE_CONTAINER, (String)AddEjbCache.CACHE_NAME)});
                ModelNode cacheAddOperation = Util.createAddOperation((PathAddress)cachePathAddress);
                for (String alias : ALIASES_ATTR_VALUE) {
                    cacheAddOperation.get(AddEjbCache.ALIASES_ATTR_NAME).add(alias);
                }
                cacheAddOperation.get(AddEjbCache.DEFAULT_CACHE_ATTR_NAME).set("passivation");
                cacheAddOperation.get(AddEjbCache.MODULE_ATTR_NAME).set(AddEjbCache.MODULE_ATTR_VALUE);
                compositeOperationBuilder.addStep(cacheAddOperation);
                AddEjbCache.addLocalCachePassivation(compositeOperationBuilder, cachePathAddress);
                AddEjbCache.addLocalCachePersistent(compositeOperationBuilder, cachePathAddress);
                configurationManagement.executeManagementOperation(compositeOperationBuilder.build().getOperation());
                context.getLogger().infof("Ejb cache added to Infinispan subsystem configuration.", new Object[0]);
                return ServerMigrationTaskResult.SUCCESS;
            }
        };
    }

    private static void addLocalCachePassivation(Operations.CompositeOperationBuilder compositeOperationBuilder, PathAddress cachePathAddress) {
        PathAddress localCachePathAddress = AddEjbCache.addLocalCache(compositeOperationBuilder, cachePathAddress, "passivation");
        AddEjbCache.setLocalCacheLocking(compositeOperationBuilder, localCachePathAddress, ISOLATION_ATTR_VALUE_REPEATABLE_READ);
        AddEjbCache.setLocalCacheTransaction(compositeOperationBuilder, localCachePathAddress, MODE_ATTR_VALUE_BATCH);
        AddEjbCache.setLocalCacheFileStore(compositeOperationBuilder, localCachePathAddress, true, false);
    }

    private static void addLocalCachePersistent(Operations.CompositeOperationBuilder compositeOperationBuilder, PathAddress cachePathAddress) {
        PathAddress localCachePathAddress = AddEjbCache.addLocalCache(compositeOperationBuilder, cachePathAddress, LOCAL_CACHE_NAME_PERSISTENCE);
        AddEjbCache.setLocalCacheLocking(compositeOperationBuilder, localCachePathAddress, ISOLATION_ATTR_VALUE_REPEATABLE_READ);
        AddEjbCache.setLocalCacheTransaction(compositeOperationBuilder, localCachePathAddress, MODE_ATTR_VALUE_BATCH);
        AddEjbCache.setLocalCacheFileStore(compositeOperationBuilder, localCachePathAddress, false, true);
    }

    private static PathAddress addLocalCache(Operations.CompositeOperationBuilder compositeOperationBuilder, PathAddress cachePathAddress, String localCacheName) {
        PathAddress localCachePathAddress = cachePathAddress.append(LOCAL_CACHE, localCacheName);
        ModelNode localCacheAddOperation = Util.createAddOperation((PathAddress)localCachePathAddress);
        compositeOperationBuilder.addStep(localCacheAddOperation);
        return localCachePathAddress;
    }

    private static void setLocalCacheLocking(Operations.CompositeOperationBuilder compositeOperationBuilder, PathAddress localCachePathAddress, String isolationValue) {
        PathAddress localCacheIsolationPathAddress = localCachePathAddress.append(COMPONENT, COMPONENT_NAME_LOCKING);
        ModelNode localCacheIsolationAddOperation = Util.createAddOperation((PathAddress)localCacheIsolationPathAddress);
        localCacheIsolationAddOperation.get(ISOLATION_ATTR_NAME).set(isolationValue);
        compositeOperationBuilder.addStep(localCacheIsolationAddOperation);
    }

    private static void setLocalCacheTransaction(Operations.CompositeOperationBuilder compositeOperationBuilder, PathAddress localCachePathAddress, String modeValue) {
        PathAddress localCacheTransactionPathAddress = localCachePathAddress.append(COMPONENT, COMPONENT_NAME_TRANSACTION);
        ModelNode localCacheTransactionAddOperation = Util.createAddOperation((PathAddress)localCacheTransactionPathAddress);
        localCacheTransactionAddOperation.get(MODE_ATTR_NAME).set(modeValue);
        compositeOperationBuilder.addStep(localCacheTransactionAddOperation);
    }

    private static void setLocalCacheFileStore(Operations.CompositeOperationBuilder compositeOperationBuilder, PathAddress localCachePathAddress, boolean passivation, boolean purge) {
        PathAddress localCacheFileStorePathAddress = localCachePathAddress.append(STORE, STORE_NAME_FILE);
        ModelNode localCacheFileStoreAddOperation = Util.createAddOperation((PathAddress)localCacheFileStorePathAddress);
        localCacheFileStoreAddOperation.get("passivation").set(passivation);
        localCacheFileStoreAddOperation.get(PURGE_ATTR_NAME).set(purge);
        compositeOperationBuilder.addStep(localCacheFileStoreAddOperation);
    }
}

