/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.wfly10.config.task.subsystem.infinispan;

import java.util.Arrays;
import java.util.List;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.dmr.ModelNode;
import org.jboss.migration.core.ServerMigrationTask;
import org.jboss.migration.core.ServerMigrationTaskContext;
import org.jboss.migration.core.ServerMigrationTaskName;
import org.jboss.migration.core.ServerMigrationTaskResult;
import org.jboss.migration.core.env.TaskEnvironment;
import org.jboss.migration.wfly10.config.management.ManageableServerConfiguration;
import org.jboss.migration.wfly10.config.management.SubsystemsManagement;
import org.jboss.migration.wfly10.config.task.subsystem.UpdateSubsystemTaskFactory;

public class FixHibernateCacheModuleName
implements UpdateSubsystemTaskFactory.SubtaskFactory {
    public static final FixHibernateCacheModuleName INSTANCE = new FixHibernateCacheModuleName();
    public static final ServerMigrationTaskName SERVER_MIGRATION_TASK_NAME = new ServerMigrationTaskName.Builder("fix-hibernate-cache-module-name").build();
    private static final String CACHE_CONTAINER = "cache-container";
    private static final String MODULE_ATTR_NAME = "module";
    private static final String DEFAULT_NEW_MODULE_NAME = "org.hibernate.infinispan";
    private static final List<String> DEFAULT_LEGACY_MODULE_NAMES = Arrays.asList("org.jboss.as.jpa.hibernate:4", "org.hibernate");

    private FixHibernateCacheModuleName() {
    }

    @Override
    public ServerMigrationTask getServerMigrationTask(ModelNode config, UpdateSubsystemTaskFactory subsystem, SubsystemsManagement subsystemsManagement) {
        return new UpdateSubsystemTaskFactory.Subtask(config, subsystem, subsystemsManagement){

            public ServerMigrationTaskName getName() {
                return SERVER_MIGRATION_TASK_NAME;
            }

            @Override
            protected ServerMigrationTaskResult run(ModelNode config, UpdateSubsystemTaskFactory subsystem, SubsystemsManagement subsystemsManagement, ServerMigrationTaskContext context, TaskEnvironment taskEnvironment) throws Exception {
                if (config == null) {
                    return ServerMigrationTaskResult.SKIPPED;
                }
                PathAddress subsystemPathAddress = subsystemsManagement.getResourcePathAddress(subsystem.getName());
                ManageableServerConfiguration configurationManagement = subsystemsManagement.getServerConfiguration();
                List legacyModuleNames = taskEnvironment.getPropertyAsList("deprecatedModuleNames", DEFAULT_LEGACY_MODULE_NAMES);
                String newModuleName = taskEnvironment.getPropertyAsString("moduleName", FixHibernateCacheModuleName.DEFAULT_NEW_MODULE_NAME);
                if (!config.hasDefined(FixHibernateCacheModuleName.CACHE_CONTAINER)) {
                    context.getLogger().infof("No Cache container", new Object[0]);
                    return ServerMigrationTaskResult.SKIPPED;
                }
                boolean configUpdated = false;
                for (String cacheName : config.get(FixHibernateCacheModuleName.CACHE_CONTAINER).keys()) {
                    ModelNode cache = config.get(new String[]{FixHibernateCacheModuleName.CACHE_CONTAINER, cacheName});
                    if (!cache.hasDefined(FixHibernateCacheModuleName.MODULE_ATTR_NAME) || !legacyModuleNames.contains(cache.get(FixHibernateCacheModuleName.MODULE_ATTR_NAME).asString())) continue;
                    ModelNode op = Util.createEmptyOperation((String)"write-attribute", (PathAddress)subsystemPathAddress.append(new PathElement[]{PathElement.pathElement((String)FixHibernateCacheModuleName.CACHE_CONTAINER, (String)cacheName)}));
                    op.get("name").set(FixHibernateCacheModuleName.MODULE_ATTR_NAME);
                    op.get("value").set(newModuleName);
                    configurationManagement.executeManagementOperation(op);
                    configUpdated = true;
                    context.getLogger().infof("Infinispan subsystem's cache %s 'module' attribute updated to %s.", (Object)cacheName, (Object)newModuleName);
                }
                return configUpdated ? ServerMigrationTaskResult.SUCCESS : ServerMigrationTaskResult.SKIPPED;
            }
        };
    }

    public static interface EnvironmentProperties {
        public static final String LEGACY_MODULE_NAMES = "deprecatedModuleNames";
        public static final String NEW_MODULE_NAME = "moduleName";
    }
}

