/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.wfly10.config.task.subsystem.securitymanager;

import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.dmr.ModelNode;
import org.jboss.migration.core.ServerMigrationTaskContext;
import org.jboss.migration.wfly10.config.management.ManageableServerConfiguration;
import org.jboss.migration.wfly10.config.management.SubsystemsManagement;
import org.jboss.migration.wfly10.config.task.subsystem.AddSubsystemConfigSubtask;

public class AddSecurityManagerSubsystem<S>
extends AddSubsystemConfigSubtask<S> {
    public static final AddSecurityManagerSubsystem INSTANCE = new AddSecurityManagerSubsystem();
    private static final String DEPLOYMENT_PERMISSIONS = "deployment-permissions";
    private static final String DEPLOYMENT_PERMISSIONS_NAME = "default";
    private static final String MAXIMUM_PERMISSIONS = "maximum-permissions";
    private static final String CLASS_ATTR_NAME = "class";
    private static final String CLASS_ATTR_VALUE = "java.security.AllPermission";

    private AddSecurityManagerSubsystem() {
        super("security-manager");
    }

    @Override
    protected void addSubsystem(SubsystemsManagement subsystemsManagement, ServerMigrationTaskContext context) throws Exception {
        ManageableServerConfiguration configurationManagement = subsystemsManagement.getServerConfiguration();
        PathAddress subsystemPathAddress = subsystemsManagement.getResourcePathAddress(this.subsystemName);
        ModelNode subsystemAddOperation = Util.createAddOperation((PathAddress)subsystemPathAddress);
        configurationManagement.executeManagementOperation(subsystemAddOperation);
        PathAddress deploymentPermissionsPathAddress = subsystemPathAddress.append(DEPLOYMENT_PERMISSIONS, DEPLOYMENT_PERMISSIONS_NAME);
        ModelNode deploymentPermissionsAddOperation = Util.createAddOperation((PathAddress)deploymentPermissionsPathAddress);
        ModelNode maximumPermissions = new ModelNode();
        maximumPermissions.get(CLASS_ATTR_NAME).set(CLASS_ATTR_VALUE);
        deploymentPermissionsAddOperation.get(MAXIMUM_PERMISSIONS).add(maximumPermissions);
        configurationManagement.executeManagementOperation(deploymentPermissionsAddOperation);
    }
}

