/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.wfly10.config.task.subsystem.undertow;

import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.dmr.ModelNode;
import org.jboss.migration.core.ServerMigrationTask;
import org.jboss.migration.core.ServerMigrationTaskContext;
import org.jboss.migration.core.ServerMigrationTaskName;
import org.jboss.migration.core.ServerMigrationTaskResult;
import org.jboss.migration.core.env.TaskEnvironment;
import org.jboss.migration.wfly10.config.management.SubsystemsManagement;
import org.jboss.migration.wfly10.config.task.subsystem.UpdateSubsystemTaskFactory;

public class AddWebsockets
implements UpdateSubsystemTaskFactory.SubtaskFactory {
    private static final String SERVLET_CONTAINER = "servlet-container";
    private static final String SERVLET_CONTAINER_NAME = "default";
    private static final String SETTING = "setting";
    private static final String SETTING_NAME = "websockets";
    public static final AddWebsockets INSTANCE = new AddWebsockets();
    public static final ServerMigrationTaskName SERVER_MIGRATION_TASK_NAME = new ServerMigrationTaskName.Builder("add-undertow-websockets").build();

    private AddWebsockets() {
    }

    @Override
    public ServerMigrationTask getServerMigrationTask(ModelNode config, UpdateSubsystemTaskFactory subsystem, SubsystemsManagement subsystemsManagement) {
        return new UpdateSubsystemTaskFactory.Subtask(config, subsystem, subsystemsManagement){

            public ServerMigrationTaskName getName() {
                return SERVER_MIGRATION_TASK_NAME;
            }

            @Override
            protected ServerMigrationTaskResult run(ModelNode config, UpdateSubsystemTaskFactory subsystem, SubsystemsManagement subsystemsManagement, ServerMigrationTaskContext context, TaskEnvironment taskEnvironment) throws Exception {
                if (config == null) {
                    return ServerMigrationTaskResult.SKIPPED;
                }
                if (!config.hasDefined(new String[]{AddWebsockets.SERVLET_CONTAINER, AddWebsockets.SERVLET_CONTAINER_NAME, AddWebsockets.SETTING, AddWebsockets.SETTING_NAME})) {
                    PathAddress pathAddress = subsystemsManagement.getResourcePathAddress(subsystem.getName()).append(new PathElement[]{PathElement.pathElement((String)AddWebsockets.SERVLET_CONTAINER, (String)AddWebsockets.SERVLET_CONTAINER_NAME), PathElement.pathElement((String)AddWebsockets.SETTING, (String)AddWebsockets.SETTING_NAME)});
                    ModelNode addOp = Util.createEmptyOperation((String)"add", (PathAddress)pathAddress);
                    subsystemsManagement.getServerConfiguration().executeManagementOperation(addOp);
                    context.getLogger().infof("Undertow's default Servlet Container configured to support Websockets.", new Object[0]);
                    return ServerMigrationTaskResult.SUCCESS;
                }
                return ServerMigrationTaskResult.SKIPPED;
            }
        };
    }
}

