/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.wfly10.config.task.update;

import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import org.jboss.migration.core.ServerMigrationTask;
import org.jboss.migration.core.ServerMigrationTaskContext;
import org.jboss.migration.core.ServerMigrationTaskName;
import org.jboss.migration.core.ServerMigrationTaskResult;
import org.jboss.migration.core.env.MigrationEnvironment;
import org.jboss.migration.core.util.xml.XMLFileFilter;
import org.jboss.migration.core.util.xml.XMLFiles;
import org.jboss.migration.wfly10.WildFly10Server;
import org.jboss.migration.wfly10.config.task.ServerConfigurationMigration;
import org.jboss.migration.wfly10.config.task.subsystem.Extension;
import org.jboss.migration.wfly10.config.task.subsystem.ExtensionBuilder;
import org.jboss.migration.wfly10.config.task.subsystem.SupportedExtensions;
import org.jboss.migration.wfly10.config.task.subsystem.WildFly10Subsystem;

public class RemoveUnsupportedExtensionsAndSubsystems<S>
implements ServerConfigurationMigration.XMLConfigurationSubtaskFactory<S> {
    public static final RemoveUnsupportedExtensionsAndSubsystems INSTANCE = new Builder().extensions(SupportedExtensions.all()).build();
    public static final ServerMigrationTaskName XML_CONFIG_SERVER_MIGRATION_TASK_NAME = new ServerMigrationTaskName.Builder("remove-unsupported-subsystems").build();
    public static final String SERVER_MIGRATION_TASK_NAME_REMOVE_SUBSYSTEM = "remove-unsupported-subsystem";
    public static final String SERVER_MIGRATION_TASK_NAME_REMOVE_EXTENSION = "remove-unsupported-extension";
    public static final String SERVER_MIGRATION_TASK_NAME_ATTRIBUTE_MODULE = "module";
    public static final String SERVER_MIGRATION_TASK_NAME_ATTRIBUTE_NAMESPACE = "namespace";
    private final List<Extension> supportedExtensions;

    protected RemoveUnsupportedExtensionsAndSubsystems(Builder builder) {
        this.supportedExtensions = Collections.unmodifiableList(builder.supportedExtensions);
    }

    @Override
    public ServerMigrationTask getTask(final S source, final Path xmlConfigurationPath, final WildFly10Server target) {
        return new ServerMigrationTask(){

            public ServerMigrationTaskName getName() {
                return XML_CONFIG_SERVER_MIGRATION_TASK_NAME;
            }

            public ServerMigrationTaskResult run(ServerMigrationTaskContext context) throws Exception {
                context.getLogger().debugf("Unsupported Extensions and Subsystems removal starting...", new Object[0]);
                RemoveUnsupportedExtensionsAndSubsystems.this.removeExtensionsAndSubsystems(source, xmlConfigurationPath, target, context);
                context.getLogger().debugf("Unsupported Extensions and Subsystems removal done.", new Object[0]);
                return ServerMigrationTaskResult.SUCCESS;
            }
        };
    }

    protected void removeExtensionsAndSubsystems(S source, Path xmlConfigurationPath, WildFly10Server targetServer, final ServerMigrationTaskContext context) throws IOException {
        final List<Extension> migrationExtensions = this.getMigrationExtensions(context.getServerMigrationContext().getMigrationEnvironment());
        final List<WildFly10Subsystem> migrationSubsystems = this.getMigrationSubsystems(migrationExtensions, context.getServerMigrationContext().getMigrationEnvironment());
        final HashSet extensionsRemoved = new HashSet();
        final HashSet subsystemsRemoved = new HashSet();
        XMLFileFilter extensionsFilter = new XMLFileFilter(){

            public XMLFileFilter.Result filter(StartElement startElement, XMLEventReader xmlEventReader, XMLEventWriter xmlEventWriter) throws IOException {
                if (startElement.getName().getLocalPart().equals("extension")) {
                    Attribute moduleAttr = startElement.getAttributeByName(new QName(RemoveUnsupportedExtensionsAndSubsystems.SERVER_MIGRATION_TASK_NAME_ATTRIBUTE_MODULE));
                    final String moduleName = moduleAttr.getValue();
                    for (Extension extension : migrationExtensions) {
                        if (!extension.getName().equals(moduleName)) continue;
                        return XMLFileFilter.Result.KEEP;
                    }
                    final ServerMigrationTaskName subtaskName = new ServerMigrationTaskName.Builder(RemoveUnsupportedExtensionsAndSubsystems.SERVER_MIGRATION_TASK_NAME_REMOVE_EXTENSION).addAttribute(RemoveUnsupportedExtensionsAndSubsystems.SERVER_MIGRATION_TASK_NAME_ATTRIBUTE_MODULE, moduleName).build();
                    ServerMigrationTask subtask = new ServerMigrationTask(){

                        public ServerMigrationTaskName getName() {
                            return subtaskName;
                        }

                        public ServerMigrationTaskResult run(ServerMigrationTaskContext context) throws Exception {
                            context.getLogger().debugf("Extension with module %s removed.", (Object)moduleName);
                            extensionsRemoved.add(moduleName);
                            return ServerMigrationTaskResult.SUCCESS;
                        }
                    };
                    context.execute(subtask);
                    return XMLFileFilter.Result.REMOVE;
                }
                return XMLFileFilter.Result.NOT_APPLICABLE;
            }
        };
        XMLFileFilter subsystemsFilter = new XMLFileFilter(){

            public XMLFileFilter.Result filter(StartElement startElement, XMLEventReader xmlEventReader, XMLEventWriter xmlEventWriter) throws IOException {
                if (startElement.getName().getLocalPart().equals("subsystem")) {
                    final String namespaceURI = startElement.getName().getNamespaceURI();
                    for (WildFly10Subsystem subsystem : migrationSubsystems) {
                        String namespaceWithoutVersion = subsystem.getNamespaceWithoutVersion();
                        if (namespaceWithoutVersion == null || !namespaceURI.startsWith(namespaceWithoutVersion + ':')) continue;
                        return XMLFileFilter.Result.KEEP;
                    }
                    final ServerMigrationTaskName subtaskName = new ServerMigrationTaskName.Builder(RemoveUnsupportedExtensionsAndSubsystems.SERVER_MIGRATION_TASK_NAME_REMOVE_SUBSYSTEM).addAttribute(RemoveUnsupportedExtensionsAndSubsystems.SERVER_MIGRATION_TASK_NAME_ATTRIBUTE_NAMESPACE, namespaceURI).build();
                    ServerMigrationTask subtask = new ServerMigrationTask(){

                        public ServerMigrationTaskName getName() {
                            return subtaskName;
                        }

                        public ServerMigrationTaskResult run(ServerMigrationTaskContext context) throws Exception {
                            context.getLogger().debugf("Subsystem with namespace %s removed.", (Object)namespaceURI);
                            subsystemsRemoved.add(namespaceURI);
                            return ServerMigrationTaskResult.SUCCESS;
                        }
                    };
                    context.execute(subtask);
                    return XMLFileFilter.Result.REMOVE;
                }
                return XMLFileFilter.Result.NOT_APPLICABLE;
            }
        };
        XMLFiles.filter((Path)xmlConfigurationPath, (XMLFileFilter[])new XMLFileFilter[]{extensionsFilter, subsystemsFilter});
        context.getLogger().infof("Unsupported extensions removed: %s", extensionsRemoved);
        context.getLogger().infof("Unsupported subsystems removed: %s", subsystemsRemoved);
    }

    private List<Extension> getMigrationExtensions(MigrationEnvironment migrationEnvironment) {
        List removedByEnv = migrationEnvironment.getPropertyAsList("extensions.remove");
        if (removedByEnv == null || removedByEnv.isEmpty()) {
            return this.supportedExtensions;
        }
        ArrayList<Extension> migrationExtensions = new ArrayList<Extension>();
        for (Extension supportedExtension : this.supportedExtensions) {
            if (removedByEnv.contains(supportedExtension.getName())) continue;
            migrationExtensions.add(supportedExtension);
        }
        return migrationExtensions;
    }

    private List<WildFly10Subsystem> getMigrationSubsystems(List<Extension> migrationExtensions, MigrationEnvironment migrationEnvironment) {
        List removedByEnv = migrationEnvironment.getPropertyAsList("subsystems.remove");
        ArrayList<WildFly10Subsystem> migrationSubsystems = new ArrayList<WildFly10Subsystem>();
        for (Extension extension : migrationExtensions) {
            for (WildFly10Subsystem subsystem : extension.getSubsystems()) {
                if (removedByEnv != null && removedByEnv.contains(subsystem.getName())) continue;
                migrationSubsystems.add(subsystem);
            }
        }
        return migrationSubsystems;
    }

    public static class Builder<S> {
        private final List<Extension> supportedExtensions = new ArrayList<Extension>();

        public Builder<S> extension(Extension extension) {
            this.supportedExtensions.add(extension);
            return this;
        }

        public Builder<S> extension(ExtensionBuilder extensionBuilder) {
            this.supportedExtensions.add(extensionBuilder.build());
            return this;
        }

        public Builder<S> extensions(Collection<Extension> extensions) {
            this.supportedExtensions.addAll(extensions);
            return this;
        }

        public RemoveUnsupportedExtensionsAndSubsystems<S> build() {
            return new RemoveUnsupportedExtensionsAndSubsystems(this);
        }
    }
}

