/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.wfly10.dist.full;

import java.util.ServiceLoader;
import org.jboss.migration.core.Server;
import org.jboss.migration.core.logger.ServerMigrationLogger;
import org.jboss.migration.wfly10.WildFly10ServerMigration;
import org.jboss.migration.wfly10.dist.full.WildFly10FullServerMigrationProvider;

public class WildFly10FullServerMigrations {
    private static final ServiceLoader<WildFly10FullServerMigrationProvider> SERVICE_LOADER = ServiceLoader.load(WildFly10FullServerMigrationProvider.class);

    private WildFly10FullServerMigrations() {
    }

    static WildFly10ServerMigration getMigrationFrom(Server sourceServer) {
        ServerMigrationLogger.ROOT_LOGGER.debugf("Retrieving server migration for source %s", sourceServer.getClass());
        for (WildFly10FullServerMigrationProvider serverMigrationProvider : SERVICE_LOADER) {
            if (!serverMigrationProvider.getSourceType().isInstance(sourceServer)) continue;
            ServerMigrationLogger.ROOT_LOGGER.debugf("Found server migration for source %s: %s", sourceServer.getClass(), serverMigrationProvider.getClass());
            return serverMigrationProvider.getServerMigration();
        }
        ServerMigrationLogger.ROOT_LOGGER.debugf("Failed to retrieve server migration for source %s", sourceServer.getClass());
        return null;
    }
}

