/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.eap6.to.eap7.tasks;

import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.dmr.ModelNode;
import org.jboss.migration.core.ParentServerMigrationTask;
import org.jboss.migration.core.ServerMigrationTaskContext;
import org.jboss.migration.wfly10.config.management.ManageableServerConfiguration;
import org.jboss.migration.wfly10.config.management.SubsystemsManagement;
import org.jboss.migration.wfly10.config.task.subsystem.AddSubsystemConfigSubtask;
import org.jboss.migration.wfly10.config.task.subsystem.AddSubsystemTaskFactory;

public class AddJmxSubsystemToHosts<S>
extends AddSubsystemTaskFactory<S> {
    public static final AddJmxSubsystemToHosts INSTANCE = new AddJmxSubsystemToHosts();

    private AddJmxSubsystemToHosts() {
        super(new AddSubsystemTaskFactory.Builder("jmx", "org.jboss.as.jmx").subtask(new AddJMXSubsystemConfig()).eventListener(new ParentServerMigrationTask.EventListener(){

            public void started(ServerMigrationTaskContext context) {
                context.getLogger().infof("Adding JMX subsystem configuration...", new Object[0]);
            }

            public void done(ServerMigrationTaskContext context) {
                context.getLogger().infof("JMX subsystem configuration added.", new Object[0]);
            }
        }));
    }

    static class AddJMXSubsystemConfig<S>
    extends AddSubsystemConfigSubtask<S> {
        private static final String EXPOSE_MODEL = "expose-model";
        private static final String RESOLVED = "resolved";
        private static final String EXPRESSION = "expression";
        private static final String REMOTING_CONNECTOR = "remoting-connector";
        private static final String JMX = "jmx";

        AddJMXSubsystemConfig() {
            super(JMX);
        }

        protected void addSubsystem(SubsystemsManagement subsystemsManagement, ServerMigrationTaskContext context) throws Exception {
            super.addSubsystem(subsystemsManagement, context);
            ManageableServerConfiguration configurationManagement = subsystemsManagement.getServerConfiguration();
            PathAddress subsystemPathAddress = subsystemsManagement.getResourcePathAddress(this.subsystemName);
            ModelNode exposeResolvedModelAddOperation = Util.createAddOperation((PathAddress)subsystemPathAddress.append(new PathElement[]{PathElement.pathElement((String)EXPOSE_MODEL, (String)RESOLVED)}));
            configurationManagement.executeManagementOperation(exposeResolvedModelAddOperation);
            ModelNode exposeExpressionModelAddOperation = Util.createAddOperation((PathAddress)subsystemPathAddress.append(new PathElement[]{PathElement.pathElement((String)EXPOSE_MODEL, (String)EXPRESSION)}));
            configurationManagement.executeManagementOperation(exposeExpressionModelAddOperation);
            ModelNode remotingConnectorAddOperation = Util.createAddOperation((PathAddress)subsystemPathAddress.append(new PathElement[]{PathElement.pathElement((String)REMOTING_CONNECTOR, (String)JMX)}));
            configurationManagement.executeManagementOperation(remotingConnectorAddOperation);
        }
    }
}

