/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.eap6.to.eap7.tasks;

import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.ValueExpression;
import org.jboss.migration.core.ParentServerMigrationTask;
import org.jboss.migration.core.ServerMigrationTask;
import org.jboss.migration.core.ServerMigrationTaskContext;
import org.jboss.migration.core.ServerMigrationTaskName;
import org.jboss.migration.core.ServerMigrationTaskResult;
import org.jboss.migration.core.env.SkippableByEnvServerMigrationTask;
import org.jboss.migration.wfly10.config.management.ManageableServerConfiguration;
import org.jboss.migration.wfly10.config.management.SocketBindingGroupManagement;
import org.jboss.migration.wfly10.config.management.SocketBindingGroupsManagement;
import org.jboss.migration.wfly10.config.management.SocketBindingsManagement;
import org.jboss.migration.wfly10.config.task.executor.SocketBindingGroupsManagementSubtaskExecutor;
import org.jboss.migration.wfly10.config.task.executor.SubtaskExecutorAdapters;
import org.jboss.migration.wfly10.config.task.factory.ManageableServerConfigurationTaskFactory;

public class AddSocketBindingPortExpressions<S>
implements ManageableServerConfigurationTaskFactory<S, ManageableServerConfiguration> {
    public static final String[] SOCKET_BINDINGS = new String[]{"ajp", "http", "https"};
    private static final ServerMigrationTaskName TASK_NAME = new ServerMigrationTaskName.Builder("add-socket-binding-port-expressions").build();
    public static final AddSocketBindingPortExpressions INSTANCE = new AddSocketBindingPortExpressions();

    private AddSocketBindingPortExpressions() {
    }

    public ServerMigrationTask getTask(S source, ManageableServerConfiguration configuration) throws Exception {
        ParentServerMigrationTask.Builder taskBuilder = new ParentServerMigrationTask.Builder(TASK_NAME).subtask(SubtaskExecutorAdapters.of(source, (ManageableServerConfiguration)configuration, new SubtaskExecutor())).eventListener(new ParentServerMigrationTask.EventListener(){

            public void started(ServerMigrationTaskContext context) {
                context.getLogger().infof("Adding socket binding's port expressions...", new Object[0]);
            }

            public void done(ServerMigrationTaskContext context) {
                context.getLogger().infof("Socket binding's port expressions added.", new Object[0]);
            }
        });
        return new SkippableByEnvServerMigrationTask((ServerMigrationTask)taskBuilder.build(), TASK_NAME + ".skip");
    }

    static class AddSocketBindingPortExpression
    implements ServerMigrationTask {
        private final String resourceName;
        private final String propertyName;
        private final ServerMigrationTaskName taskName;
        private final SocketBindingsManagement resourceManagement;

        AddSocketBindingPortExpression(String resourceName, ServerMigrationTaskName taskName, String propertyName, SocketBindingsManagement resourceManagement) {
            this.resourceName = resourceName;
            this.propertyName = propertyName;
            this.resourceManagement = resourceManagement;
            this.taskName = taskName;
        }

        public ServerMigrationTaskName getName() {
            return this.taskName;
        }

        public ServerMigrationTaskResult run(ServerMigrationTaskContext context) throws Exception {
            ModelNode resource = this.resourceManagement.getResource(this.resourceName);
            if (resource == null) {
                context.getLogger().debugf("Socket binding %s does not exists, task to add port property skipped.", (Object)this.resourceName);
                return ServerMigrationTaskResult.SKIPPED;
            }
            if (!resource.hasDefined("port")) {
                context.getLogger().debugf("Socket binding %s has no port defined, task to add port property skipped.", (Object)this.resourceName);
                return ServerMigrationTaskResult.SKIPPED;
            }
            ModelNode resourceAttr = resource.get("port");
            if (resourceAttr.getType() == ModelType.EXPRESSION) {
                context.getLogger().debugf("Socket binding %s unexpected port value %s, task to add port property skipped.", (Object)this.resourceName, (Object)resourceAttr.asExpression().getExpressionString());
                return ServerMigrationTaskResult.SKIPPED;
            }
            ValueExpression valueExpression = new ValueExpression("${" + this.propertyName + ":" + resourceAttr.asString() + "}");
            PathAddress pathAddress = this.resourceManagement.getResourcePathAddress(this.resourceName);
            ModelNode writeAttrOp = Util.createEmptyOperation((String)"write-attribute", (PathAddress)pathAddress);
            writeAttrOp.get("name").set("port");
            writeAttrOp.get("value").set(valueExpression);
            this.resourceManagement.getServerConfiguration().executeManagementOperation(writeAttrOp);
            context.getLogger().infof("Socket binding %s port value expression set as %s.", (Object)pathAddress.toCLIStyleString(), (Object)valueExpression.getExpressionString());
            return ServerMigrationTaskResult.SUCCESS;
        }
    }

    public static class SubtaskExecutor<S>
    implements SocketBindingGroupsManagementSubtaskExecutor<S> {
        public void executeSubtasks(S source, SocketBindingGroupsManagement resourceManagement, ServerMigrationTaskContext context) throws Exception {
            for (String socketBindingGroupName : resourceManagement.getResourceNames()) {
                context.getLogger().debugf("Processing socket binding group %s...", (Object)socketBindingGroupName);
                SocketBindingGroupManagement socketBindingGroupManagement = resourceManagement.getSocketBindingGroupManagement(socketBindingGroupName);
                for (String socketBindingName : SOCKET_BINDINGS) {
                    ServerMigrationTaskName subtaskName = new ServerMigrationTaskName.Builder("add-" + socketBindingName + "-port-expression").addAttribute("group", socketBindingGroupManagement.getSocketBindingGroupName()).build();
                    String propertyName = "jboss." + socketBindingName + ".port";
                    AddSocketBindingPortExpression subtask = new AddSocketBindingPortExpression(socketBindingName, subtaskName, propertyName, socketBindingGroupManagement.getSocketBindingsManagement());
                    context.execute((ServerMigrationTask)new SkippableByEnvServerMigrationTask((ServerMigrationTask)subtask, TASK_NAME + "." + subtaskName.getName() + ".skip"));
                }
            }
        }
    }
}

