/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.eap6.to.eap7.tasks;

import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.dmr.ModelNode;
import org.jboss.migration.core.ParentServerMigrationTask;
import org.jboss.migration.core.ServerMigrationTask;
import org.jboss.migration.core.ServerMigrationTaskContext;
import org.jboss.migration.core.ServerMigrationTaskName;
import org.jboss.migration.core.ServerMigrationTaskResult;
import org.jboss.migration.core.env.MigrationEnvironment;
import org.jboss.migration.core.env.SkippableByEnvServerMigrationTask;
import org.jboss.migration.wfly10.config.management.HostConfiguration;
import org.jboss.migration.wfly10.config.management.ManagementInterfacesManagement;
import org.jboss.migration.wfly10.config.management.SocketBindingGroupManagement;
import org.jboss.migration.wfly10.config.management.SocketBindingGroupsManagement;
import org.jboss.migration.wfly10.config.management.SocketBindingsManagement;
import org.jboss.migration.wfly10.config.management.StandaloneServerConfiguration;
import org.jboss.migration.wfly10.config.task.executor.ManagementInterfacesManagementSubtaskExecutor;
import org.jboss.migration.wfly10.config.task.executor.SocketBindingGroupsManagementSubtaskExecutor;
import org.jboss.migration.wfly10.config.task.factory.HostConfigurationTaskFactory;
import org.jboss.migration.wfly10.config.task.factory.StandaloneServerConfigurationTaskFactory;

public class SetupHttpUpgradeManagement<S>
implements StandaloneServerConfigurationTaskFactory<S>,
HostConfigurationTaskFactory<S> {
    public static final SetupHttpUpgradeManagement INSTANCE = new SetupHttpUpgradeManagement();
    private static final String TASK_NAME_NAME = "setup-http-upgrade-management";
    private static final ServerMigrationTaskName TASK_NAME = new ServerMigrationTaskName.Builder("setup-http-upgrade-management").build();

    private SetupHttpUpgradeManagement() {
    }

    public ServerMigrationTask getTask(final S source, final StandaloneServerConfiguration configuration) throws Exception {
        ParentServerMigrationTask.SubtaskExecutor subtaskExecutor = new ParentServerMigrationTask.SubtaskExecutor(){

            public void executeSubtasks(ServerMigrationTaskContext context) throws Exception {
                new SetManagementInterfacesHttpUpgradeEnabled<Object>().executeSubtasks(source, configuration.getManagementInterfacesManagement(), context);
                new UpdateManagementHttpsSocketBindingPort<Object>().executeSubtasks(source, configuration.getSocketBindingGroupsManagement(), context);
            }
        };
        return this.getTask(subtaskExecutor);
    }

    public ServerMigrationTask getTask(final S source, final HostConfiguration configuration) throws Exception {
        ParentServerMigrationTask.SubtaskExecutor subtaskExecutor = new ParentServerMigrationTask.SubtaskExecutor(){

            public void executeSubtasks(ServerMigrationTaskContext context) throws Exception {
                new SetManagementInterfacesHttpUpgradeEnabled<Object>().executeSubtasks(source, configuration.getManagementInterfacesManagement(), context);
            }
        };
        return this.getTask(subtaskExecutor);
    }

    protected ServerMigrationTask getTask(ParentServerMigrationTask.SubtaskExecutor subtaskExecutor) throws Exception {
        ParentServerMigrationTask parentTask = new ParentServerMigrationTask.Builder(TASK_NAME).eventListener(new ParentServerMigrationTask.EventListener(){

            public void started(ServerMigrationTaskContext context) {
                context.getLogger().debugf("HTTP upgrade management setup starting...", new Object[0]);
            }

            public void done(ServerMigrationTaskContext context) {
                context.getLogger().debugf("HTTP upgrade management setup completed.", new Object[0]);
            }
        }).subtask(subtaskExecutor).build();
        return new SkippableByEnvServerMigrationTask((ServerMigrationTask)parentTask, TASK_NAME + ".skip");
    }

    static class UpdateManagementHttpsSocketBindingPort<S>
    implements SocketBindingGroupsManagementSubtaskExecutor<S> {
        public static final String SERVER_MIGRATION_TASK_NAME_NAME = "update-management-https-socket-binding-port";
        public static final ServerMigrationTaskName SERVER_MIGRATION_TASK_NAME = new ServerMigrationTaskName.Builder("update-management-https-socket-binding-port").build();
        public static final String DEFAULT_PORT = "${jboss.management.https.port:9993}";
        private final String SOCKET_BINDING_NAME = "management-https";
        private final String SOCKET_BINDING_PORT_ATTR = "port";

        UpdateManagementHttpsSocketBindingPort() {
        }

        public void executeSubtasks(S source, SocketBindingGroupsManagement socketBindingGroupsManagement, ServerMigrationTaskContext context) throws Exception {
            for (String socketBindingGroup : socketBindingGroupsManagement.getResourceNames()) {
                SocketBindingGroupManagement socketBindingGroupManagement = socketBindingGroupsManagement.getSocketBindingGroupManagement(socketBindingGroup);
                final SocketBindingsManagement socketBindingsManagement = socketBindingGroupManagement.getSocketBindingsManagement();
                ServerMigrationTask subtask = new ServerMigrationTask(){

                    public ServerMigrationTaskName getName() {
                        return SERVER_MIGRATION_TASK_NAME;
                    }

                    public ServerMigrationTaskResult run(ServerMigrationTaskContext context) throws Exception {
                        MigrationEnvironment env = context.getServerMigrationContext().getMigrationEnvironment();
                        String envPropertyPort = env.getPropertyAsString("setup-http-upgrade-management.update-management-https-socket-binding-port.port");
                        if (envPropertyPort == null || envPropertyPort.isEmpty()) {
                            envPropertyPort = UpdateManagementHttpsSocketBindingPort.DEFAULT_PORT;
                        }
                        if (!socketBindingsManagement.getResourceNames().contains("management-https")) {
                            return ServerMigrationTaskResult.SKIPPED;
                        }
                        PathAddress pathAddress = socketBindingsManagement.getResourcePathAddress("management-https");
                        ModelNode writeAttrOp = Util.createEmptyOperation((String)"write-attribute", (PathAddress)pathAddress);
                        writeAttrOp.get("name").set("port");
                        writeAttrOp.get("value").set(envPropertyPort);
                        socketBindingsManagement.getServerConfiguration().executeManagementOperation(writeAttrOp);
                        context.getLogger().infof("Socket binding '%s' port set to " + envPropertyPort + ".", (Object)"management-https");
                        return ServerMigrationTaskResult.SUCCESS;
                    }
                };
                context.execute(subtask);
            }
        }

        public static interface EnvironmentProperties {
            public static final String PROPERTIES_PREFIX = "setup-http-upgrade-management.update-management-https-socket-binding-port.";
            public static final String PORT = "setup-http-upgrade-management.update-management-https-socket-binding-port.port";
        }
    }

    static class SetManagementInterfacesHttpUpgradeEnabled<S>
    implements ManagementInterfacesManagementSubtaskExecutor<S> {
        public static final String SERVER_MIGRATION_TASK_NAME_NAME = "set-management-interfaces-http-upgrade-enabled";
        public static final ServerMigrationTaskName SERVER_MIGRATION_TASK_NAME = new ServerMigrationTaskName.Builder("set-management-interfaces-http-upgrade-enabled").build();
        private static final String MANAGEMENT_INTERFACE_NAME = "http-interface";

        SetManagementInterfacesHttpUpgradeEnabled() {
        }

        public void executeSubtasks(S source, final ManagementInterfacesManagement resourceManagement, ServerMigrationTaskContext context) throws Exception {
            ServerMigrationTask subtask = new ServerMigrationTask(){

                public ServerMigrationTaskName getName() {
                    return SERVER_MIGRATION_TASK_NAME;
                }

                public ServerMigrationTaskResult run(ServerMigrationTaskContext context) throws Exception {
                    ModelNode resource = resourceManagement.getResource(SetManagementInterfacesHttpUpgradeEnabled.MANAGEMENT_INTERFACE_NAME);
                    if (resource == null) {
                        context.getLogger().debugf("Management interface %s does not exists.", (Object)SetManagementInterfacesHttpUpgradeEnabled.MANAGEMENT_INTERFACE_NAME);
                        return ServerMigrationTaskResult.SKIPPED;
                    }
                    if (resource.hasDefined("http-upgrade-enabled") && resource.get("http-upgrade-enabled").asBoolean()) {
                        context.getLogger().debugf("Management interface %s http upgrade already enabled.", (Object)SetManagementInterfacesHttpUpgradeEnabled.MANAGEMENT_INTERFACE_NAME);
                        return ServerMigrationTaskResult.SKIPPED;
                    }
                    PathAddress pathAddress = resourceManagement.getResourcePathAddress(SetManagementInterfacesHttpUpgradeEnabled.MANAGEMENT_INTERFACE_NAME);
                    ModelNode writeAttrOp = Util.createEmptyOperation((String)"write-attribute", (PathAddress)pathAddress);
                    writeAttrOp.get("name").set("http-upgrade-enabled");
                    writeAttrOp.get("value").set(true);
                    resourceManagement.getServerConfiguration().executeManagementOperation(writeAttrOp);
                    context.getLogger().debugf("Management interface '%s' http upgrade enabled.", (Object)SetManagementInterfacesHttpUpgradeEnabled.MANAGEMENT_INTERFACE_NAME);
                    return ServerMigrationTaskResult.SUCCESS;
                }
            };
            context.execute((ServerMigrationTask)new SkippableByEnvServerMigrationTask(subtask, "setup-http-upgrade-management.set-management-interfaces-http-upgrade-enabled.skip"));
        }
    }
}

