/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.eap;

import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import org.jboss.migration.core.AbstractServerProvider;
import org.jboss.migration.core.JBossServer;
import org.jboss.migration.core.ManifestProductInfo;
import org.jboss.migration.core.ProductInfo;
import org.jboss.migration.core.Server;
import org.jboss.migration.core.env.MigrationEnvironment;
import org.jboss.migration.eap.EAP6Server;

public class EAP6ServerProvider
extends AbstractServerProvider {
    protected ProductInfo getProductInfo(Path baseDir, MigrationEnvironment migrationEnvironment) throws IllegalArgumentException, IOException {
        Path manifestPath = JBossServer.getModulesFile((Path)baseDir, (Path)FileSystems.getDefault().getPath("org", new String[0]).resolve("jboss").resolve("as").resolve("product").resolve("eap").resolve("dir").resolve("META-INF").resolve("MANIFEST.MF"));
        ManifestProductInfo productInfo = ManifestProductInfo.from((Path)manifestPath);
        return productInfo;
    }

    protected String getProductNameRegex() {
        return "EAP";
    }

    protected String getProductVersionRegex() {
        return "6\\..*";
    }

    protected Server constructServer(String migrationName, ProductInfo productInfo, Path baseDir, MigrationEnvironment migrationEnvironment) {
        return new EAP6Server(migrationName, productInfo, baseDir, migrationEnvironment);
    }

    public String getName() {
        return "JBoss EAP 6";
    }
}

