/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.cli;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.jboss.migration.cli.logger.CommandLineMigrationLogger;
import org.wildfly.security.manager.WildFlySecurityManager;

public abstract class CommandLineArgumentUsage {
    private static String USAGE;
    private static final String NEW_LINE;
    private static final List<List<String>> arguments;
    protected static List<String> instructions;

    protected static void addArguments(String ... args) {
        ArrayList tempArguments = new ArrayList();
        Collections.addAll(tempArguments, args);
        arguments.add(tempArguments);
    }

    private static String getCommand(int i) {
        ArrayList<String> segmentedInstructions = new ArrayList<String>();
        CommandLineArgumentUsage.segmentInstructions(instructions.get(i), segmentedInstructions);
        ArrayList<String> segmentedArguments = new ArrayList<String>();
        CommandLineArgumentUsage.segmentArguments(arguments.get(i), segmentedArguments, 0);
        StringBuilder output = new StringBuilder(String.format("    %-35s %s", segmentedArguments.remove(0), segmentedInstructions.remove(0)));
        output.append(NEW_LINE);
        if (segmentedArguments.size() <= segmentedInstructions.size()) {
            int count = 0;
            for (String arg : segmentedArguments) {
                output.append(String.format("         %-30s %s", arg, segmentedInstructions.remove(count)));
                output.append(NEW_LINE);
                ++count;
            }
            for (String instruction : segmentedInstructions) {
                output.append(String.format("%-40s%s", " ", instruction));
                output.append(NEW_LINE);
            }
        } else {
            int count = 0;
            for (String instruction : segmentedInstructions) {
                output.append(String.format("         %-30s %s", segmentedArguments.remove(count), instruction));
                output.append(NEW_LINE);
                ++count;
            }
            for (String arg : segmentedArguments) {
                output.append(String.format("         %-30s", arg));
                output.append(NEW_LINE);
            }
        }
        output.append(NEW_LINE);
        return output.toString();
    }

    private static void segmentArguments(List<String> input, List<String> output, int depth) {
        int width = 30;
        if (depth == 0) {
            width = 35;
        }
        if (input.size() > 0) {
            StringBuilder argumentsString = new StringBuilder();
            int i = 0;
            while (i < input.size()) {
                if (input.get(0).length() > width) {
                    String tooLong = input.remove(0);
                    input.add(0, tooLong.substring(0, width - 5));
                }
                if (input.size() == 1 && argumentsString.toString().length() + input.get(0).length() <= width) {
                    argumentsString.append(input.remove(0));
                    continue;
                }
                if (argumentsString.toString().length() + input.get(0).length() + 2 > width) break;
                argumentsString.append(input.remove(0)).append(", ");
            }
            output.add(argumentsString.toString());
            CommandLineArgumentUsage.segmentArguments(input, output, depth + 1);
        }
    }

    private static void segmentInstructions(String instructions, List<String> segments) {
        if (instructions.length() <= 40) {
            segments.add(instructions);
        } else {
            String testFragment = instructions.substring(0, 40);
            int lastSpace = testFragment.lastIndexOf(32);
            if (lastSpace < 0) {
                lastSpace = 39;
            }
            segments.add(instructions.substring(0, lastSpace + 1));
            CommandLineArgumentUsage.segmentInstructions(instructions.substring(lastSpace + 1), segments);
        }
    }

    protected static String usage(String executableBaseName) {
        String executableName;
        boolean isWindows = WildFlySecurityManager.getPropertyPrivileged((String)"os.name", null).toLowerCase(Locale.ENGLISH).contains("windows");
        String string = executableName = isWindows ? executableBaseName : executableBaseName + ".sh";
        if (USAGE == null) {
            StringBuilder sb = new StringBuilder();
            sb.append(NEW_LINE).append(CommandLineMigrationLogger.ROOT_LOGGER.argUsage(executableName)).append(NEW_LINE);
            for (int i = 0; i < arguments.size(); ++i) {
                sb.append(CommandLineArgumentUsage.getCommand(i)).append(NEW_LINE);
            }
            USAGE = sb.toString();
        }
        return USAGE;
    }

    static {
        NEW_LINE = String.format("%n", new Object[0]);
        arguments = new ArrayList<List<String>>();
        instructions = new ArrayList<String>();
    }
}

