/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.cli;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;
import org.jboss.migration.cli.CommandLineArgumentUsageImpl;
import org.jboss.migration.core.MigrationData;
import org.jboss.migration.core.ServerMigration;
import org.jboss.migration.core.env.MigrationEnvironment;
import org.jboss.migration.core.env.SystemEnvironment;
import org.jboss.migration.core.logger.ServerMigrationLogger;
import org.jboss.migration.core.report.HtmlReportWriter;
import org.jboss.migration.core.report.XmlReportWriter;
import org.jboss.migration.core.task.ServerMigrationTaskResult;
import org.wildfly.security.manager.WildFlySecurityManager;

public class CommandLineServerMigration {
    private static final PrintStream STDOUT = System.out;
    private static final PrintStream STDERR = System.err;

    private static void usage() {
        CommandLineArgumentUsageImpl.printUsage(STDOUT);
    }

    private CommandLineServerMigration() {
    }

    public static void main(String[] args) {
        WildFlySecurityManager.setPropertyPrivileged((String)"java.util.logging.manager", (String)"org.jboss.logmanager.LogManager");
        try {
            String baseDir;
            if (args.length < 4) {
                CommandLineServerMigration.usage();
                CommandLineServerMigration.abort(null);
            }
            Path source = null;
            Path target = null;
            Path environment = null;
            Boolean interactive = null;
            block18: for (int i = 0; i < args.length; ++i) {
                String arg;
                switch (arg = args[i]) {
                    case "--environment": {
                        if (++i == args.length || environment != null) {
                            CommandLineServerMigration.usage();
                            CommandLineServerMigration.abort(null);
                        }
                        environment = CommandLineServerMigration.resolvePath(args[i]);
                        continue block18;
                    }
                    case "--interactive": {
                        if (++i == args.length || interactive != null) {
                            CommandLineServerMigration.usage();
                            CommandLineServerMigration.abort(null);
                        }
                        interactive = Boolean.valueOf(args[i]);
                        continue block18;
                    }
                    case "--source": {
                        if (++i == args.length || source != null) {
                            CommandLineServerMigration.usage();
                            CommandLineServerMigration.abort(null);
                        }
                        source = CommandLineServerMigration.resolvePath(args[i]);
                        continue block18;
                    }
                    case "--target": {
                        if (++i == args.length || target != null) {
                            CommandLineServerMigration.usage();
                            CommandLineServerMigration.abort(null);
                        }
                        target = CommandLineServerMigration.resolvePath(args[i]);
                    }
                }
            }
            if (interactive == null) {
                interactive = true;
            }
            if ((baseDir = SystemEnvironment.INSTANCE.getPropertyAsString("baseDir")) == null) {
                throw new RuntimeException("system environment does not specifies the tool's base dir");
            }
            Path baseDirPath = Paths.get(baseDir, new String[0]);
            Path configDirPath = baseDirPath.resolve("configuration");
            Path reportsDirPath = baseDirPath.resolve("reports");
            MigrationEnvironment userEnvironment = new MigrationEnvironment();
            Path configDirEnvironment = configDirPath.resolve("environment.properties");
            if (Files.exists(configDirEnvironment, new LinkOption[0])) {
                userEnvironment.setProperties(CommandLineServerMigration.loadProperties(configDirEnvironment));
            }
            if (environment != null) {
                userEnvironment.setProperties(CommandLineServerMigration.loadProperties(environment));
            }
            MigrationData migrationData = new ServerMigration().from(source).to(target).interactive(interactive.booleanValue()).userEnvironment(userEnvironment).run();
            String htmlReportFileName = userEnvironment.getPropertyAsString("report.html.fileName");
            String xmlReportFileName = userEnvironment.getPropertyAsString("report.xml.fileName");
            if (htmlReportFileName != null) {
                try {
                    String htmlReportTemplateFileName = userEnvironment.getPropertyAsString("report.html.templateFileName", "migration-report-template.html");
                    Path htmlReportTemplatePath = configDirPath.resolve(htmlReportTemplateFileName);
                    HtmlReportWriter.INSTANCE.toPath(reportsDirPath.resolve(htmlReportFileName), migrationData, HtmlReportWriter.ReportTemplate.from((Path)htmlReportTemplatePath));
                }
                catch (Throwable e) {
                    ServerMigrationLogger.ROOT_LOGGER.error((Object)"HTML Report write failed", e);
                }
            }
            if (xmlReportFileName != null) {
                try {
                    XmlReportWriter.INSTANCE.writeContent(reportsDirPath.resolve(xmlReportFileName).toFile(), migrationData);
                }
                catch (Throwable e) {
                    ServerMigrationLogger.ROOT_LOGGER.error((Object)"XML Report write failed", e);
                }
            }
            if (migrationData.getRootTask().getResult().getStatus() == ServerMigrationTaskResult.Status.FAIL) {
                System.exit(1);
            }
        }
        catch (Throwable t) {
            CommandLineServerMigration.abort(t);
        }
    }

    private static Properties loadProperties(Path propertiesFilePath) throws IOException {
        Properties properties = new Properties();
        try (InputStream inputStream = Files.newInputStream(propertiesFilePath, new OpenOption[0]);){
            properties.load(inputStream);
        }
        return properties;
    }

    private static void abort(Throwable t) {
        try {
            if (t != null) {
                t.printStackTrace(STDERR);
            }
        }
        finally {
            System.exit(1);
        }
    }

    private static Path resolvePath(String s) throws IllegalArgumentException {
        Path absolutePath;
        Path path = Paths.get(s, new String[0]).normalize();
        Path path2 = absolutePath = path.isAbsolute() ? path : Paths.get(System.getProperty("user.dir"), new String[0]).resolve(path);
        if (!Files.exists(absolutePath, new LinkOption[0])) {
            throw new IllegalArgumentException("File " + absolutePath + " does not exists.");
        }
        return absolutePath;
    }
}

