/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.eap6.to.eap7;

import java.io.IOException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.migration.core.ServerMigrationContext;
import org.jboss.migration.core.logger.ServerMigrationLogger;
import org.jboss.migration.wfly10.standalone.WildFly10StandaloneServer;

public class EAP6ToEAP7StandaloneConfigFileSocketBindingsMigration {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(WildFly10StandaloneServer target, ServerMigrationContext context) throws IOException {
        context.getConsoleWrapper().printf("%n%n", new Object[0]);
        ServerMigrationLogger.ROOT_LOGGER.infof("Migrating socket bindings...", new Object[0]);
        boolean targetStarted = target.isStarted();
        if (!targetStarted) {
            target.start();
        }
        try {
            ModelNode op = Util.createEmptyOperation((String)"read-children-resources", (PathAddress)PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"socket-binding-group", (String)"standard-sockets")}));
            op.get("child-type").set("socket-binding");
            op.get("recursive").set(true);
            ModelNode opResult = target.executeManagementOperation(op);
            ServerMigrationLogger.ROOT_LOGGER.debugf("Get socket bindings Op result %s", (Object)opResult.toString());
            for (ModelNode resultItem : opResult.get("result").asList()) {
                Property socketBinding = resultItem.asProperty();
                if (!socketBinding.getName().equals("management-https")) continue;
                PathAddress pathAddress = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"socket-binding-group", (String)"standard-sockets"), PathElement.pathElement((String)"socket-binding", (String)"management-https")});
                ModelNode writeAttrOp = Util.createEmptyOperation((String)"write-attribute", (PathAddress)pathAddress);
                writeAttrOp.get("name").set("port");
                writeAttrOp.get("value").set("${jboss.management.https.port:9993}");
                target.executeManagementOperation(writeAttrOp);
                ServerMigrationLogger.ROOT_LOGGER.infof("Socket binding 'management-https' default port set to 9993.", new Object[0]);
            }
        }
        finally {
            if (!targetStarted) {
                target.stop();
            }
            ServerMigrationLogger.ROOT_LOGGER.info((Object)"Socket bindings migration done.");
        }
    }
}

