/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.eap6.to.eap7.tasks;

import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ValueExpression;
import org.jboss.migration.core.ParentServerMigrationTask;
import org.jboss.migration.core.ServerMigrationTask;
import org.jboss.migration.core.ServerMigrationTaskContext;
import org.jboss.migration.core.ServerMigrationTaskName;
import org.jboss.migration.core.ServerMigrationTaskResult;
import org.jboss.migration.core.env.SkippableByEnvServerMigrationTask;
import org.jboss.migration.wfly10.config.management.HostConfiguration;
import org.jboss.migration.wfly10.config.management.HostControllerConfiguration;
import org.jboss.migration.wfly10.config.management.InterfacesManagement;
import org.jboss.migration.wfly10.config.task.executor.InterfacesManagementSubtaskExecutor;
import org.jboss.migration.wfly10.config.task.factory.DomainConfigurationTaskFactory;
import org.jboss.migration.wfly10.config.task.factory.HostConfigurationTaskFactory;

public class UpdateUnsecureInterface<S>
implements DomainConfigurationTaskFactory<S>,
HostConfigurationTaskFactory<S> {
    public static final UpdateUnsecureInterface INSTANCE = new UpdateUnsecureInterface();
    private static final String TASK_NAME_NAME = "update-unsecure-interface";
    private static final ServerMigrationTaskName TASK_NAME = new ServerMigrationTaskName.Builder("update-unsecure-interface").build();

    private UpdateUnsecureInterface() {
    }

    public ServerMigrationTask getTask(final S source, final HostControllerConfiguration configuration) throws Exception {
        ParentServerMigrationTask.SubtaskExecutor subtaskExecutor = new ParentServerMigrationTask.SubtaskExecutor(){

            public void executeSubtasks(ServerMigrationTaskContext context) throws Exception {
                new SetUnsecureInterfaceInetAddress<Object>().executeSubtasks(source, configuration.getInterfacesManagement(), context);
            }
        };
        return this.getTask(subtaskExecutor);
    }

    public ServerMigrationTask getTask(final S source, final HostConfiguration configuration) throws Exception {
        ParentServerMigrationTask.SubtaskExecutor subtaskExecutor = new ParentServerMigrationTask.SubtaskExecutor(){

            public void executeSubtasks(ServerMigrationTaskContext context) throws Exception {
                new RemoveUnsecureInterface<Object>().executeSubtasks(source, configuration.getInterfacesManagement(), context);
            }
        };
        return this.getTask(subtaskExecutor);
    }

    protected ServerMigrationTask getTask(ParentServerMigrationTask.SubtaskExecutor subtaskExecutor) throws Exception {
        ParentServerMigrationTask parentTask = new ParentServerMigrationTask.Builder(TASK_NAME).eventListener(new ParentServerMigrationTask.EventListener(){

            public void started(ServerMigrationTaskContext context) {
                context.getLogger().debugf("Updating unsecure interface configuration...", new Object[0]);
            }

            public void done(ServerMigrationTaskContext context) {
                context.getLogger().debugf("Unsecure interface configuration updated.", new Object[0]);
            }
        }).subtask(subtaskExecutor).build();
        return new SkippableByEnvServerMigrationTask((ServerMigrationTask)parentTask, TASK_NAME + ".skip");
    }

    static class RemoveUnsecureInterface<S>
    implements InterfacesManagementSubtaskExecutor<S> {
        public static final String SERVER_MIGRATION_TASK_NAME_NAME = "remove-unsecure-interface";
        public static final ServerMigrationTaskName SERVER_MIGRATION_TASK_NAME = new ServerMigrationTaskName.Builder("remove-unsecure-interface").build();
        private static final String INTERFACE_NAME = "unsecure";

        RemoveUnsecureInterface() {
        }

        public void executeSubtasks(S source, final InterfacesManagement resourceManagement, ServerMigrationTaskContext context) throws Exception {
            ServerMigrationTask subtask = new ServerMigrationTask(){

                public ServerMigrationTaskName getName() {
                    return SERVER_MIGRATION_TASK_NAME;
                }

                public ServerMigrationTaskResult run(ServerMigrationTaskContext context) throws Exception {
                    if (!resourceManagement.getResourceNames().contains(RemoveUnsecureInterface.INTERFACE_NAME)) {
                        context.getLogger().debugf("Interface %s does not exists.", (Object)RemoveUnsecureInterface.INTERFACE_NAME);
                        return ServerMigrationTaskResult.SKIPPED;
                    }
                    PathAddress pathAddress = resourceManagement.getResourcePathAddress(RemoveUnsecureInterface.INTERFACE_NAME);
                    ModelNode removeOp = Util.createRemoveOperation((PathAddress)pathAddress);
                    resourceManagement.getServerConfiguration().executeManagementOperation(removeOp);
                    context.getLogger().infof("Interface %s removed.", (Object)RemoveUnsecureInterface.INTERFACE_NAME);
                    return ServerMigrationTaskResult.SUCCESS;
                }
            };
            context.execute((ServerMigrationTask)new SkippableByEnvServerMigrationTask(subtask, "update-unsecure-interface.remove-unsecure-interface.skip"));
        }
    }

    static class SetUnsecureInterfaceInetAddress<S>
    implements InterfacesManagementSubtaskExecutor<S> {
        public static final String SERVER_MIGRATION_TASK_NAME_NAME = "set-unsecure-interface-inet-address";
        public static final ServerMigrationTaskName SERVER_MIGRATION_TASK_NAME = new ServerMigrationTaskName.Builder("set-unsecure-interface-inet-address").build();
        private static final String INTERFACE_NAME = "unsecure";

        SetUnsecureInterfaceInetAddress() {
        }

        public void executeSubtasks(S source, final InterfacesManagement resourceManagement, ServerMigrationTaskContext context) throws Exception {
            ServerMigrationTask subtask = new ServerMigrationTask(){

                public ServerMigrationTaskName getName() {
                    return SERVER_MIGRATION_TASK_NAME;
                }

                public ServerMigrationTaskResult run(ServerMigrationTaskContext context) throws Exception {
                    ModelNode resource = resourceManagement.getResource(SetUnsecureInterfaceInetAddress.INTERFACE_NAME);
                    if (resource == null) {
                        context.getLogger().debugf("Interface %s does not exists.", (Object)SetUnsecureInterfaceInetAddress.INTERFACE_NAME);
                        return ServerMigrationTaskResult.SKIPPED;
                    }
                    if (resource.hasDefined("inet-address")) {
                        context.getLogger().debugf("Interface %s inet address already defined.", (Object)SetUnsecureInterfaceInetAddress.INTERFACE_NAME);
                        return ServerMigrationTaskResult.SKIPPED;
                    }
                    ValueExpression valueExpression = new ValueExpression("${jboss.bind.address.unsecure:127.0.0.1}");
                    PathAddress pathAddress = resourceManagement.getResourcePathAddress(SetUnsecureInterfaceInetAddress.INTERFACE_NAME);
                    ModelNode writeAttrOp = Util.createEmptyOperation((String)"write-attribute", (PathAddress)pathAddress);
                    writeAttrOp.get("name").set("inet-address");
                    writeAttrOp.get("value").set(valueExpression);
                    resourceManagement.getServerConfiguration().executeManagementOperation(writeAttrOp);
                    context.getLogger().infof("Interface %s inet address value set as %s.", (Object)SetUnsecureInterfaceInetAddress.INTERFACE_NAME, (Object)valueExpression.getExpressionString());
                    return ServerMigrationTaskResult.SUCCESS;
                }
            };
            context.execute((ServerMigrationTask)new SkippableByEnvServerMigrationTask(subtask, "update-unsecure-interface.set-unsecure-interface-inet-address.skip"));
        }
    }
}

