/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.eap.task.subsystem.elytron;

import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.dmr.ModelNode;

public class FileAuditLogAddOperation {
    private final PathAddress subsystemPathAddress;
    private final String fileAuditLog;
    private String path;
    private String relativeTo;
    private String format;

    public FileAuditLogAddOperation(PathAddress subsystemPathAddress, String fileAuditLog) {
        this.subsystemPathAddress = subsystemPathAddress;
        this.fileAuditLog = fileAuditLog;
    }

    public FileAuditLogAddOperation path(String path) {
        this.path = path;
        return this;
    }

    public FileAuditLogAddOperation relativeTo(String relativeTo) {
        this.relativeTo = relativeTo;
        return this;
    }

    public FileAuditLogAddOperation format(String format) {
        this.format = format;
        return this;
    }

    public ModelNode toModelNode() {
        PathAddress pathAddress = this.subsystemPathAddress.append("file-audit-log", this.fileAuditLog);
        ModelNode operation = Util.createAddOperation((PathAddress)pathAddress);
        if (this.path != null) {
            operation.get("path").set(this.path);
        }
        if (this.relativeTo != null) {
            operation.get("relative-to").set(this.relativeTo);
        }
        if (this.format != null) {
            operation.get("format").set(this.format);
        }
        return operation;
    }
}

