/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.eap.task.subsystem.elytron;

import java.util.ArrayList;
import java.util.List;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.dmr.ModelNode;

public class SecurityDomainAddOperation {
    private final PathAddress subsystemPathAddress;
    private final String securityDomain;
    private String defaultRealm;
    private String permissionMapper;
    private String securityEventListener;
    private List<Realm> realms;

    public SecurityDomainAddOperation(PathAddress subsystemPathAddress, String securityDomain) {
        this.subsystemPathAddress = subsystemPathAddress;
        this.securityDomain = securityDomain;
        this.realms = new ArrayList<Realm>();
    }

    public SecurityDomainAddOperation permissionMapper(String permissionMapper) {
        this.permissionMapper = permissionMapper;
        return this;
    }

    public SecurityDomainAddOperation defaultRealm(String defaultRealm) {
        this.defaultRealm = defaultRealm;
        return this;
    }

    public SecurityDomainAddOperation securityEventListener(String securityEventListener) {
        this.securityEventListener = securityEventListener;
        return this;
    }

    public SecurityDomainAddOperation addRealm(Realm realm) {
        this.realms.add(realm);
        return this;
    }

    public ModelNode toModelNode() {
        PathAddress pathAddress = this.subsystemPathAddress.append("security-domain", this.securityDomain);
        ModelNode operation = Util.createAddOperation((PathAddress)pathAddress);
        if (this.permissionMapper != null) {
            operation.get("permission-mapper").set(this.permissionMapper);
        }
        if (this.defaultRealm != null) {
            operation.get("default-realm").set(this.defaultRealm);
        }
        if (this.securityEventListener != null) {
            operation.get("security-event-listener").set(this.securityEventListener);
        }
        if (this.realms != null && !this.realms.isEmpty()) {
            ModelNode operationRealms = operation.get("realms").setEmptyList();
            for (Realm realm : this.realms) {
                operationRealms.add(realm.toModelNode());
            }
        }
        return operation;
    }

    public static class Realm {
        private final String realm;
        private String roleDecoder;
        private String roleMapper;

        public Realm(String realm) {
            this.realm = realm;
        }

        public Realm roleDecoder(String roleDecoder) {
            this.roleDecoder = roleDecoder;
            return this;
        }

        public Realm roleMapper(String roleMapper) {
            this.roleMapper = roleMapper;
            return this;
        }

        ModelNode toModelNode() {
            ModelNode modelNode = new ModelNode();
            modelNode.get("realm").set(this.realm);
            if (this.roleDecoder != null) {
                modelNode.get("role-decoder").set(this.roleDecoder);
            }
            if (this.roleMapper != null) {
                modelNode.get("role-mapper").set(this.roleMapper);
            }
            return modelNode;
        }
    }
}

