/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.eap.task.subsystem.elytron;

import java.util.ArrayList;
import java.util.List;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.dmr.ModelNode;

public class SubsystemAddOperation {
    private final PathAddress subsystemPathAddress;
    private String finalProviders;
    private List<String> disallowedProviders;

    public SubsystemAddOperation(PathAddress subsystemPathAddress) {
        this.subsystemPathAddress = subsystemPathAddress;
        this.disallowedProviders = new ArrayList<String>();
    }

    public SubsystemAddOperation finalProviders(String finalProviders) {
        this.finalProviders = finalProviders;
        return this;
    }

    public SubsystemAddOperation addDisallowedProvider(String disallowedProvider) {
        this.disallowedProviders.add(disallowedProvider);
        return this;
    }

    public ModelNode toModelNode() {
        ModelNode operation = Util.createAddOperation((PathAddress)this.subsystemPathAddress);
        if (this.finalProviders != null) {
            operation.get("final-providers").set(this.finalProviders);
        }
        if (this.disallowedProviders != null && !this.disallowedProviders.isEmpty()) {
            ModelNode disallowedProvidersNode = operation.get("disallowed-providers").setEmptyList();
            for (String disallowedProvider : this.disallowedProviders) {
                disallowedProvidersNode.add(disallowedProvider);
            }
        }
        return operation;
    }
}

