/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.eap.task.subsystem.elytron;

import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.client.helpers.Operations;
import org.jboss.migration.core.task.TaskContext;
import org.jboss.migration.core.task.component.TaskSkipPolicy;
import org.jboss.migration.eap.task.subsystem.elytron.AggregateProvidersAddOperation;
import org.jboss.migration.eap.task.subsystem.elytron.ConfigurableSaslServerFactoryAddOperation;
import org.jboss.migration.eap.task.subsystem.elytron.ConstantRealmMapperAddOperation;
import org.jboss.migration.eap.task.subsystem.elytron.ConstantRoleMapperAddOperation;
import org.jboss.migration.eap.task.subsystem.elytron.FileAuditLogAddOperation;
import org.jboss.migration.eap.task.subsystem.elytron.HttpAuthenticationFactoryAddOperation;
import org.jboss.migration.eap.task.subsystem.elytron.IdentityRealmAddOperation;
import org.jboss.migration.eap.task.subsystem.elytron.MechanismConfiguration;
import org.jboss.migration.eap.task.subsystem.elytron.MechanismProviderFilteringSaslServerFactoryAddOperation;
import org.jboss.migration.eap.task.subsystem.elytron.MechanismRealmConfiguration;
import org.jboss.migration.eap.task.subsystem.elytron.Permission;
import org.jboss.migration.eap.task.subsystem.elytron.PermissionMapping;
import org.jboss.migration.eap.task.subsystem.elytron.PropertiesRealmAddOperation;
import org.jboss.migration.eap.task.subsystem.elytron.ProviderHttpServerMechanismFactoryAddOperation;
import org.jboss.migration.eap.task.subsystem.elytron.ProviderLoaderAddOperation;
import org.jboss.migration.eap.task.subsystem.elytron.ProviderSaslServerFactoryAddOperation;
import org.jboss.migration.eap.task.subsystem.elytron.SaslAuthenticationFactoryAddOperation;
import org.jboss.migration.eap.task.subsystem.elytron.SecurityDomainAddOperation;
import org.jboss.migration.eap.task.subsystem.elytron.SimplePermissionMapperAddOperation;
import org.jboss.migration.eap.task.subsystem.elytron.SimpleRoleDecoderAddOperation;
import org.jboss.migration.eap.task.subsystem.elytron.SubsystemAddOperation;
import org.jboss.migration.wfly10.config.management.HostConfiguration;
import org.jboss.migration.wfly10.config.management.HostControllerConfiguration;
import org.jboss.migration.wfly10.config.management.ManageableServerConfiguration;
import org.jboss.migration.wfly10.config.management.ManageableServerConfigurationType;
import org.jboss.migration.wfly10.config.management.StandaloneServerConfiguration;
import org.jboss.migration.wfly10.config.management.SubsystemResource;
import org.jboss.migration.wfly10.config.task.management.resource.ManageableResourceBuildParameters;
import org.jboss.migration.wfly10.config.task.management.subsystem.AddSubsystemResourceSubtaskBuilder;

public class AddElytronSubsystemConfig<S>
extends AddSubsystemResourceSubtaskBuilder<S> {
    protected AddElytronSubsystemConfig() {
        super("elytron");
        this.skipPolicy(TaskSkipPolicy.skipIfDefaultTaskSkipPropertyIsSet());
    }

    protected void addConfiguration(ManageableResourceBuildParameters<S, SubsystemResource.Parent> params, TaskContext taskContext) {
        ManageableServerConfiguration configuration = params.getServerConfiguration();
        PathAddress subsystemPathAddress = ((SubsystemResource.Parent)params.getResource()).getSubsystemResourcePathAddress(this.getSubsystem());
        Operations.CompositeOperationBuilder compositeOperationBuilder = Operations.CompositeOperationBuilder.create();
        this.addOperationSteps(configuration, subsystemPathAddress, compositeOperationBuilder);
        configuration.executeManagementOperation(compositeOperationBuilder.build().getOperation());
    }

    protected void addOperationSteps(ManageableServerConfiguration configuration, PathAddress subsystemPathAddress, Operations.CompositeOperationBuilder compositeOperationBuilder) {
        this.addSubsystem(configuration, subsystemPathAddress, compositeOperationBuilder);
        this.addProviders(configuration, subsystemPathAddress, compositeOperationBuilder);
        this.addAuditLogging(configuration, subsystemPathAddress, compositeOperationBuilder);
        this.addSecurityDomains(configuration, subsystemPathAddress, compositeOperationBuilder);
        this.addSecurityRealms(configuration, subsystemPathAddress, compositeOperationBuilder);
        this.addMappers(configuration, subsystemPathAddress, compositeOperationBuilder);
        this.addHttp(configuration, subsystemPathAddress, compositeOperationBuilder);
        this.addSasl(configuration, subsystemPathAddress, compositeOperationBuilder);
    }

    protected void addSubsystem(ManageableServerConfiguration configuration, PathAddress subsystemPathAddress, Operations.CompositeOperationBuilder compositeOperationBuilder) {
        compositeOperationBuilder.addStep(new SubsystemAddOperation(subsystemPathAddress).finalProviders("combined-providers").addDisallowedProvider("OracleUcrypto").toModelNode());
    }

    protected void addProviders(ManageableServerConfiguration configuration, PathAddress subsystemPathAddress, Operations.CompositeOperationBuilder compositeOperationBuilder) {
        compositeOperationBuilder.addStep(new ProviderLoaderAddOperation(subsystemPathAddress, "elytron").module("org.wildfly.security.elytron").toModelNode());
        compositeOperationBuilder.addStep(new ProviderLoaderAddOperation(subsystemPathAddress, "openssl").module("org.wildfly.openssl").toModelNode());
        compositeOperationBuilder.addStep(new AggregateProvidersAddOperation(subsystemPathAddress, "combined-providers").addProvider("elytron").addProvider("openssl").toModelNode());
    }

    protected void addAuditLogging(ManageableServerConfiguration configuration, PathAddress subsystemPathAddress, Operations.CompositeOperationBuilder compositeOperationBuilder) {
        compositeOperationBuilder.addStep(new FileAuditLogAddOperation(subsystemPathAddress, "local-audit").path("audit.log").relativeTo(configuration.getConfigurationType() != HostConfiguration.RESOURCE_TYPE ? "jboss.server.log.dir" : "jboss.domain.log.dir").format("JSON").toModelNode());
    }

    protected void addSecurityDomains(ManageableServerConfiguration configuration, PathAddress subsystemPathAddress, Operations.CompositeOperationBuilder compositeOperationBuilder) {
        ManageableServerConfigurationType configurationType = configuration.getConfigurationType();
        if (configurationType == StandaloneServerConfiguration.RESOURCE_TYPE || configurationType == HostControllerConfiguration.RESOURCE_TYPE) {
            SecurityDomainAddOperation securityDomainAddOperation = new SecurityDomainAddOperation(subsystemPathAddress, "ApplicationDomain").permissionMapper("default-permission-mapper").defaultRealm("ApplicationRealm").addRealm(new SecurityDomainAddOperation.Realm("ApplicationRealm").roleDecoder("groups-to-roles"));
            if (configurationType == StandaloneServerConfiguration.RESOURCE_TYPE) {
                securityDomainAddOperation.addRealm(new SecurityDomainAddOperation.Realm("local"));
            }
            compositeOperationBuilder.addStep(securityDomainAddOperation.toModelNode());
        }
        if (configurationType == StandaloneServerConfiguration.RESOURCE_TYPE || configurationType == HostConfiguration.RESOURCE_TYPE) {
            compositeOperationBuilder.addStep(new SecurityDomainAddOperation(subsystemPathAddress, "ManagementDomain").permissionMapper("default-permission-mapper").defaultRealm("ManagementRealm").addRealm(new SecurityDomainAddOperation.Realm("ManagementRealm").roleDecoder("groups-to-roles")).addRealm(new SecurityDomainAddOperation.Realm("local").roleMapper("super-user-mapper")).toModelNode());
        }
    }

    protected void addSecurityRealms(ManageableServerConfiguration configuration, PathAddress subsystemPathAddress, Operations.CompositeOperationBuilder compositeOperationBuilder) {
        ManageableServerConfigurationType configurationType = configuration.getConfigurationType();
        compositeOperationBuilder.addStep(new IdentityRealmAddOperation(subsystemPathAddress, "local").identity("$local").toModelNode());
        if (configurationType == StandaloneServerConfiguration.RESOURCE_TYPE || configurationType == HostControllerConfiguration.RESOURCE_TYPE) {
            compositeOperationBuilder.addStep(new PropertiesRealmAddOperation(subsystemPathAddress, "ApplicationRealm").usersProperties(new PropertiesRealmAddOperation.Properties("application-users.properties").relativeTo(configurationType == StandaloneServerConfiguration.RESOURCE_TYPE ? "jboss.server.config.dir" : "jboss.domain.config.dir").digestRealmName("ApplicationRealm")).groupsProperties(new PropertiesRealmAddOperation.Properties("application-roles.properties").relativeTo(configurationType == StandaloneServerConfiguration.RESOURCE_TYPE ? "jboss.server.config.dir" : "jboss.domain.config.dir")).toModelNode());
        }
        if (configurationType == StandaloneServerConfiguration.RESOURCE_TYPE || configurationType == HostConfiguration.RESOURCE_TYPE) {
            compositeOperationBuilder.addStep(new PropertiesRealmAddOperation(subsystemPathAddress, "ManagementRealm").usersProperties(new PropertiesRealmAddOperation.Properties("mgmt-users.properties").relativeTo(configurationType == StandaloneServerConfiguration.RESOURCE_TYPE ? "jboss.server.config.dir" : "jboss.domain.config.dir").digestRealmName("ManagementRealm")).groupsProperties(new PropertiesRealmAddOperation.Properties("mgmt-groups.properties").relativeTo(configurationType == StandaloneServerConfiguration.RESOURCE_TYPE ? "jboss.server.config.dir" : "jboss.domain.config.dir")).toModelNode());
        }
    }

    protected void addMappers(ManageableServerConfiguration configuration, PathAddress subsystemPathAddress, Operations.CompositeOperationBuilder compositeOperationBuilder) {
        ManageableServerConfigurationType configurationType = configuration.getConfigurationType();
        PermissionMapping anonymousPermissionMapping = new PermissionMapping().addPrincipal("anonymous");
        if (configurationType == StandaloneServerConfiguration.RESOURCE_TYPE || configurationType == HostControllerConfiguration.RESOURCE_TYPE) {
            anonymousPermissionMapping.addPermission(new Permission("org.wildfly.extension.batch.jberet.deployment.BatchPermission").module("org.wildfly.extension.batch.jberet").targetName("*")).addPermission(new Permission("org.wildfly.transaction.client.RemoteTransactionPermission").module("org.wildfly.transaction.client")).addPermission(new Permission("org.jboss.ejb.client.RemoteEJBPermission").module("org.jboss.ejb-client"));
        }
        PermissionMapping matchAllPermissionMapping = new PermissionMapping().matchAll(true).addPermission(new Permission("org.wildfly.security.auth.permission.LoginPermission"));
        if (configurationType == StandaloneServerConfiguration.RESOURCE_TYPE || configurationType == HostControllerConfiguration.RESOURCE_TYPE) {
            matchAllPermissionMapping.addPermission(new Permission("org.wildfly.extension.batch.jberet.deployment.BatchPermission").module("org.wildfly.extension.batch.jberet").targetName("*")).addPermission(new Permission("org.wildfly.transaction.client.RemoteTransactionPermission").module("org.wildfly.transaction.client")).addPermission(new Permission("org.jboss.ejb.client.RemoteEJBPermission").module("org.jboss.ejb-client"));
        }
        compositeOperationBuilder.addStep(new SimplePermissionMapperAddOperation(subsystemPathAddress, "default-permission-mapper").mappingMode("first").addPermissionMapping(anonymousPermissionMapping).addPermissionMapping(matchAllPermissionMapping).toModelNode());
        compositeOperationBuilder.addStep(new ConstantRealmMapperAddOperation(subsystemPathAddress, "local").realmName("local").toModelNode());
        compositeOperationBuilder.addStep(new SimpleRoleDecoderAddOperation(subsystemPathAddress, "groups-to-roles").attribute("groups").toModelNode());
        compositeOperationBuilder.addStep(new ConstantRoleMapperAddOperation(subsystemPathAddress, "super-user-mapper").addRole("SuperUser").toModelNode());
    }

    protected void addHttp(ManageableServerConfiguration configuration, PathAddress subsystemPathAddress, Operations.CompositeOperationBuilder compositeOperationBuilder) {
        ManageableServerConfigurationType configurationType = configuration.getConfigurationType();
        if (configurationType == StandaloneServerConfiguration.RESOURCE_TYPE) {
            compositeOperationBuilder.addStep(new HttpAuthenticationFactoryAddOperation(subsystemPathAddress, "management-http-authentication").securityDomain("ManagementDomain").httpServerMechanismFactory("global").addMechanismConfiguration(new MechanismConfiguration("DIGEST").addMechanismRealmConfiguration(new MechanismRealmConfiguration("ManagementRealm"))).toModelNode());
        } else if (configurationType == HostConfiguration.RESOURCE_TYPE) {
            compositeOperationBuilder.addStep(new HttpAuthenticationFactoryAddOperation(subsystemPathAddress, "management-http-authentication").securityDomain("ManagementDomain").httpServerMechanismFactory("global").addMechanismConfiguration(new MechanismConfiguration("BASIC").addMechanismRealmConfiguration(new MechanismRealmConfiguration("Management Realm"))).toModelNode());
        }
        if (configurationType == StandaloneServerConfiguration.RESOURCE_TYPE || configurationType == HostControllerConfiguration.RESOURCE_TYPE) {
            compositeOperationBuilder.addStep(new HttpAuthenticationFactoryAddOperation(subsystemPathAddress, "application-http-authentication").securityDomain("ApplicationDomain").httpServerMechanismFactory("global").addMechanismConfiguration(new MechanismConfiguration("BASIC").addMechanismRealmConfiguration(new MechanismRealmConfiguration("Application Realm"))).addMechanismConfiguration(new MechanismConfiguration("FORM")).toModelNode());
        }
        compositeOperationBuilder.addStep(new ProviderHttpServerMechanismFactoryAddOperation(subsystemPathAddress, "global").toModelNode());
    }

    protected void addSasl(ManageableServerConfiguration configuration, PathAddress subsystemPathAddress, Operations.CompositeOperationBuilder compositeOperationBuilder) {
        ManageableServerConfigurationType configurationType = configuration.getConfigurationType();
        if (configurationType == StandaloneServerConfiguration.RESOURCE_TYPE || configurationType == HostConfiguration.RESOURCE_TYPE) {
            compositeOperationBuilder.addStep(new SaslAuthenticationFactoryAddOperation(subsystemPathAddress, "management-sasl-authentication").securityDomain("ManagementDomain").saslServerFactory("configured").addMechanismConfiguration(new MechanismConfiguration("JBOSS-LOCAL-USER").realmMapper("local")).addMechanismConfiguration(new MechanismConfiguration("DIGEST-MD5").addMechanismRealmConfiguration(new MechanismRealmConfiguration("ManagementRealm"))).toModelNode());
        }
        if (configurationType == StandaloneServerConfiguration.RESOURCE_TYPE || configurationType == HostControllerConfiguration.RESOURCE_TYPE) {
            compositeOperationBuilder.addStep(new SaslAuthenticationFactoryAddOperation(subsystemPathAddress, "application-sasl-authentication").securityDomain("ApplicationDomain").saslServerFactory("configured").addMechanismConfiguration(new MechanismConfiguration("JBOSS-LOCAL-USER").realmMapper("local")).addMechanismConfiguration(new MechanismConfiguration("DIGEST-MD5").addMechanismRealmConfiguration(new MechanismRealmConfiguration("ApplicationRealm"))).toModelNode());
        }
        compositeOperationBuilder.addStep(new ProviderSaslServerFactoryAddOperation(subsystemPathAddress, "global").toModelNode());
        compositeOperationBuilder.addStep(new MechanismProviderFilteringSaslServerFactoryAddOperation(subsystemPathAddress, "elytron").saslServerFactory("global").addFilter("WildFlyElytron").toModelNode());
        compositeOperationBuilder.addStep(new ConfigurableSaslServerFactoryAddOperation(subsystemPathAddress, "configured").saslServerFactory("elytron").addProperty("wildfly.sasl.local-user.default-user", "$local").toModelNode());
    }
}

