/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.eap.task.subsystem.elytron;

import java.util.ArrayList;
import java.util.List;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.dmr.ModelNode;
import org.jboss.migration.eap.task.subsystem.elytron.MechanismConfiguration;

public class SaslAuthenticationFactoryAddOperation {
    private final PathAddress subsystemPathAddress;
    private final String saslAuthenticationFactory;
    private String securityDomain;
    private String saslServerFactory;
    private List<MechanismConfiguration> mechanismConfigurations;

    public SaslAuthenticationFactoryAddOperation(PathAddress subsystemPathAddress, String saslAuthenticationFactory) {
        this.subsystemPathAddress = subsystemPathAddress;
        this.saslAuthenticationFactory = saslAuthenticationFactory;
        this.mechanismConfigurations = new ArrayList<MechanismConfiguration>();
    }

    public SaslAuthenticationFactoryAddOperation securityDomain(String securityDomain) {
        this.securityDomain = securityDomain;
        return this;
    }

    public SaslAuthenticationFactoryAddOperation saslServerFactory(String saslServerFactory) {
        this.saslServerFactory = saslServerFactory;
        return this;
    }

    public SaslAuthenticationFactoryAddOperation addMechanismConfiguration(MechanismConfiguration mechanismConfiguration) {
        this.mechanismConfigurations.add(mechanismConfiguration);
        return this;
    }

    public ModelNode toModelNode() {
        PathAddress pathAddress = this.subsystemPathAddress.append("sasl-authentication-factory", this.saslAuthenticationFactory);
        ModelNode operation = Util.createAddOperation((PathAddress)pathAddress);
        if (this.securityDomain != null) {
            operation.get("security-domain").set(this.securityDomain);
        }
        if (this.saslServerFactory != null) {
            operation.get("sasl-server-factory").set(this.saslServerFactory);
        }
        if (this.mechanismConfigurations != null && !this.mechanismConfigurations.isEmpty()) {
            ModelNode mechanismConfigurationsNode = operation.get("mechanism-configurations").setEmptyList();
            for (MechanismConfiguration mechanismConfiguration : this.mechanismConfigurations) {
                mechanismConfigurationsNode.add(mechanismConfiguration.toModelNode());
            }
        }
        return operation;
    }
}

