/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.eap.task.subsystem.logging;

import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.client.helpers.Operations;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.dmr.ModelNode;
import org.jboss.migration.core.env.TaskEnvironment;
import org.jboss.migration.core.task.ServerMigrationTaskResult;
import org.jboss.migration.core.task.TaskContext;
import org.jboss.migration.wfly10.config.management.SubsystemResource;
import org.jboss.migration.wfly10.config.task.management.subsystem.UpdateSubsystemResourceSubtaskBuilder;
import org.jboss.migration.wfly10.config.task.management.subsystem.UpdateSubsystemResources;

public class RemoveConsoleHandlerFromLoggingSubsystem<S>
extends UpdateSubsystemResources<S> {
    public RemoveConsoleHandlerFromLoggingSubsystem() {
        super("logging", new UpdateSubsystemResourceSubtaskBuilder[]{new SubtaskBuilder()});
    }

    static class SubtaskBuilder<S>
    extends UpdateSubsystemResourceSubtaskBuilder<S> {
        public static final String TASK_NAME = "remove-console-handler";
        private static final String CONSOLE_HANDLER = "console-handler";
        private static final String CONSOLE = "CONSOLE";
        private static final String REMOVE_HANDLER = "remove-handler";
        private static final String ROOT_LOGGER = "root-logger";
        private static final String ROOT = "ROOT";
        private static final String NAME = "name";

        SubtaskBuilder() {
            this.subtaskName(TASK_NAME);
        }

        protected ServerMigrationTaskResult updateConfiguration(ModelNode config, S source, SubsystemResource subsystemResource, TaskContext context, TaskEnvironment taskEnvironment) {
            if (!config.hasDefined(new String[]{CONSOLE_HANDLER, CONSOLE})) {
                context.getLogger().infof("Console handler not found, skipping.", new Object[0]);
                return ServerMigrationTaskResult.SKIPPED;
            }
            Operations.CompositeOperationBuilder compositeOperationBuilder = Operations.CompositeOperationBuilder.create();
            compositeOperationBuilder.addStep(Util.createEmptyOperation((String)"remove", (PathAddress)subsystemResource.getResourcePathAddress().append(CONSOLE_HANDLER, CONSOLE)));
            ModelNode removeHandlerOp = Util.createEmptyOperation((String)REMOVE_HANDLER, (PathAddress)subsystemResource.getResourcePathAddress().append(ROOT_LOGGER, ROOT));
            removeHandlerOp.get(NAME).set(CONSOLE);
            compositeOperationBuilder.addStep(removeHandlerOp);
            subsystemResource.getServerConfiguration().executeManagementOperation(compositeOperationBuilder.build().getOperation());
            context.getLogger().infof("Console handler removed.", new Object[0]);
            return ServerMigrationTaskResult.SUCCESS;
        }
    }
}

