/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.wfly10.config.task.module;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.jboss.migration.core.ServerMigrationFailureException;
import org.jboss.migration.core.env.SkippableByEnvServerMigrationTask;
import org.jboss.migration.core.jboss.JBossServer;
import org.jboss.migration.core.jboss.JBossServerConfiguration;
import org.jboss.migration.core.jboss.ModulesMigrationTask;
import org.jboss.migration.core.task.ServerMigrationTask;
import org.jboss.migration.core.task.ServerMigrationTaskName;
import org.jboss.migration.core.task.TaskContext;
import org.jboss.migration.wfly10.config.task.ServerConfigurationMigration;

public class ConfigurationModulesMigrationTaskFactory<S extends JBossServer<S>>
implements ServerConfigurationMigration.XMLConfigurationSubtaskFactory<JBossServerConfiguration<S>> {
    private final Map<String, List<ModulesFinder>> modulesFinders;

    protected ConfigurationModulesMigrationTaskFactory(Builder<S> builder) {
        this.modulesFinders = Collections.unmodifiableMap(((Builder)builder).modulesFinders);
    }

    @Override
    public ServerMigrationTask getTask(JBossServerConfiguration<S> source, JBossServerConfiguration targetConfigurationPath) {
        return new SkippableByEnvServerMigrationTask((ServerMigrationTask)new Task(source.getServer(), targetConfigurationPath, this.modulesFinders));
    }

    public static class Builder<S extends JBossServer<S>> {
        private final Map<String, List<ModulesFinder>> modulesFinders = new HashMap<String, List<ModulesFinder>>();

        public synchronized Builder<S> modulesFinder(ModulesFinder modulesFinder) {
            List<ModulesFinder> elementModulesFinders = this.modulesFinders.get(modulesFinder.getElementLocalName());
            if (elementModulesFinders == null) {
                elementModulesFinders = new ArrayList<ModulesFinder>();
                this.modulesFinders.put(modulesFinder.getElementLocalName(), elementModulesFinders);
            }
            elementModulesFinders.add(modulesFinder);
            return this;
        }

        public ConfigurationModulesMigrationTaskFactory<S> build() {
            return new ConfigurationModulesMigrationTaskFactory(this);
        }
    }

    public static interface ModulesFinder {
        public String getElementLocalName();

        public void processElement(XMLStreamReader var1, ModulesMigrationTask.ModuleMigrator var2, TaskContext var3) throws IOException;
    }

    private static class Task
    extends ModulesMigrationTask {
        private final ServerMigrationTaskName taskName;
        private final JBossServerConfiguration targetConfigurationPath;
        private final Map<String, List<ModulesFinder>> modulesFinders;

        public Task(JBossServer source, JBossServerConfiguration targetConfigurationPath, Map<String, List<ModulesFinder>> modulesFinders) {
            super(source, targetConfigurationPath.getServer(), "configuration");
            this.taskName = new ServerMigrationTaskName.Builder("modules.migrate-modules-requested-by-configuration").addAttribute("path", targetConfigurationPath.getPath().toString()).build();
            this.targetConfigurationPath = targetConfigurationPath;
            this.modulesFinders = modulesFinders;
        }

        public ServerMigrationTaskName getName() {
            return this.taskName;
        }

        protected void migrateModules(ModulesMigrationTask.ModuleMigrator moduleMigrator, TaskContext context) {
            context.getLogger().debugf("Migrating modules referenced by the configuration...", new Object[0]);
            try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(this.targetConfigurationPath.getPath().toFile()));){
                XMLStreamReader reader = XMLInputFactory.newInstance().createXMLStreamReader(in);
                reader.require(7, null, null);
                while (reader.hasNext()) {
                    if (reader.next() != 1) continue;
                    this.processElement(reader, moduleMigrator, context);
                }
            }
            catch (Exception e) {
                throw new ServerMigrationFailureException((Throwable)e);
            }
            if (!context.hasSucessfulSubtasks()) {
                context.getLogger().debugf("No referenced modules to migrate.", new Object[0]);
            }
        }

        protected void processElement(XMLStreamReader reader, ModulesMigrationTask.ModuleMigrator moduleMigrator, TaskContext context) throws IOException {
            List<ModulesFinder> elementModulesFinders = this.modulesFinders.get(reader.getLocalName());
            if (elementModulesFinders != null) {
                for (ModulesFinder modulesFinder : elementModulesFinders) {
                    modulesFinder.processElement(reader, moduleMigrator, context);
                }
            }
        }
    }
}

