/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.wfly10.config.task.update;

import java.util.ArrayList;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ValueExpression;
import org.jboss.migration.core.task.ServerMigrationTaskName;
import org.jboss.migration.core.task.ServerMigrationTaskResult;
import org.jboss.migration.core.task.component.TaskSkipPolicy;
import org.jboss.migration.wfly10.config.management.ManageableServerConfiguration;
import org.jboss.migration.wfly10.config.management.SocketBindingGroupResource;
import org.jboss.migration.wfly10.config.management.SocketBindingResource;
import org.jboss.migration.wfly10.config.task.management.configuration.ManageableServerConfigurationCompositeSubtasks;
import org.jboss.migration.wfly10.config.task.management.configuration.ManageableServerConfigurationCompositeTask;
import org.jboss.migration.wfly10.config.task.management.configuration.ManageableServerConfigurationLeafTask;
import org.jboss.migration.wfly10.config.task.management.resource.ManageableResourceLeafTask;
import org.jboss.migration.wfly10.config.task.management.resource.ManageableResourceTaskRunnableBuilder;

public class AddPrivateInterface<S>
extends ManageableServerConfigurationCompositeTask.Builder<S> {
    private static final String INTERFACE_NAME = "private";
    private static final String[] SOCKET_BINDING_NAMES = new String[]{"jgroups-mping", "jgroups-tcp", "jgroups-tcp-fd", "jgroups-udp", "jgroups-udp-fd"};
    private static final String TASK_NAME = "interface.private.setup";

    public AddPrivateInterface() {
        this.name(TASK_NAME);
        this.skipPolicyBuilders(new TaskSkipPolicy.Builder[]{TaskSkipPolicy.Builders.skipIfDefaultTaskSkipPropertyIsSet(), buildParameters -> context -> {
            for (String socketBindingName : SOCKET_BINDING_NAMES) {
                if (buildParameters.getServerConfiguration().findResources(SocketBindingResource.class, socketBindingName).isEmpty()) continue;
                return false;
            }
            return true;
        }});
        this.beforeRun(context -> context.getLogger().debugf("Adding interface %s...", (Object)INTERFACE_NAME));
        this.subtasks(((ManageableServerConfigurationCompositeSubtasks.Builder)new ManageableServerConfigurationCompositeSubtasks.Builder().subtask(new AddInterface())).subtask(SocketBindingGroupResource.class, new UpdateSocketBindings()));
        this.afterRun(context -> {
            if (context.hasSucessfulSubtasks()) {
                context.getLogger().infof("Interface %s added.", (Object)INTERFACE_NAME);
            }
        });
    }

    protected static class UpdateSocketBindings<S>
    extends ManageableResourceLeafTask.Builder<S, SocketBindingGroupResource> {
        protected UpdateSocketBindings() {
            this.nameBuilder(params -> new ServerMigrationTaskName.Builder("interface.private.setup.update-socket-binding-group-" + ((SocketBindingGroupResource)params.getResource()).getResourceName()).build());
            this.skipPolicy(TaskSkipPolicy.skipIfDefaultTaskSkipPropertyIsSet());
            ManageableResourceTaskRunnableBuilder runnableBuilder = params -> context -> {
                ArrayList<String> updated = new ArrayList<String>();
                for (String socketBinding : SOCKET_BINDING_NAMES) {
                    ModelNode config;
                    SocketBindingResource socketBindingResource = ((SocketBindingGroupResource)params.getResource()).getSocketBindingResource(socketBinding);
                    if (socketBindingResource == null || (config = socketBindingResource.getResourceConfiguration()) == null || config.hasDefined("interface") && config.get("interface").asString().equals(AddPrivateInterface.INTERFACE_NAME)) continue;
                    PathAddress pathAddress = socketBindingResource.getResourcePathAddress();
                    ModelNode writeAttrOp = Util.createEmptyOperation((String)"write-attribute", (PathAddress)pathAddress);
                    writeAttrOp.get("name").set("interface");
                    writeAttrOp.get("value").set(AddPrivateInterface.INTERFACE_NAME);
                    socketBindingResource.getServerConfiguration().executeManagementOperation(writeAttrOp);
                    context.getLogger().debugf("Socket binding %s interface set to %s", (Object)socketBindingResource.getResourceAbsoluteName(), (Object)AddPrivateInterface.INTERFACE_NAME);
                    updated.add(socketBinding);
                }
                if (updated.isEmpty()) {
                    return ServerMigrationTaskResult.SKIPPED;
                }
                return new ServerMigrationTaskResult.Builder().success().addAttribute("updated", (Object)((Object)updated).toString()).build();
            };
            this.runBuilder(runnableBuilder);
        }
    }

    protected static class AddInterface<S>
    extends ManageableServerConfigurationLeafTask.Builder<S> {
        protected AddInterface() {
            this.name("interface.private.setup.add-config");
            this.skipPolicy(TaskSkipPolicy.skipIfDefaultTaskSkipPropertyIsSet());
            this.runBuilder(params -> context -> {
                ManageableServerConfiguration serverConfiguration = params.getServerConfiguration();
                if (serverConfiguration.getInterfaceResourceNames().contains(AddPrivateInterface.INTERFACE_NAME)) {
                    context.getLogger().debugf("Skipping task to add interface private, the configuration already has it.", new Object[0]);
                    return ServerMigrationTaskResult.SKIPPED;
                }
                ModelNode addInterfaceOp = Util.createAddOperation((PathAddress)serverConfiguration.getInterfaceResourcePathAddress(AddPrivateInterface.INTERFACE_NAME));
                addInterfaceOp.get("inet-address").set(new ValueExpression("${jboss.bind.address.private:127.0.0.1}"));
                serverConfiguration.executeManagementOperation(addInterfaceOp);
                context.getLogger().debugf("Interface %s added.", (Object)AddPrivateInterface.INTERFACE_NAME);
                return ServerMigrationTaskResult.SUCCESS;
            });
        }
    }
}

