/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.core;

import java.nio.file.Path;
import java.util.regex.Pattern;
import org.jboss.migration.core.ProductInfo;
import org.jboss.migration.core.Server;
import org.jboss.migration.core.ServerMigrationFailureException;
import org.jboss.migration.core.ServerProvider;
import org.jboss.migration.core.env.MigrationEnvironment;
import org.jboss.migration.core.logger.ServerMigrationLogger;

public abstract class AbstractServerProvider
implements ServerProvider {
    @Override
    public Server getServer(String migrationName, Path baseDir, MigrationEnvironment migrationEnvironment) throws ServerMigrationFailureException {
        ProductInfo productInfo = this.getProductInfo(baseDir, migrationEnvironment);
        return this.isProviderFor(productInfo) ? this.constructServer(migrationName, productInfo, baseDir, migrationEnvironment) : null;
    }

    protected abstract ProductInfo getProductInfo(Path var1, MigrationEnvironment var2) throws ServerMigrationFailureException;

    protected boolean isProviderFor(ProductInfo productInfo) {
        if (productInfo == null) {
            return false;
        }
        String productName = productInfo.getName();
        if (productName == null || !Pattern.matches(this.getProductNameRegex(), productName)) {
            ServerMigrationLogger.ROOT_LOGGER.debugf("Product name %s doesn't match!", productName);
            return false;
        }
        String productVersion = productInfo.getVersion();
        if (productVersion == null || !Pattern.matches(this.getProductVersionRegex(), productVersion)) {
            ServerMigrationLogger.ROOT_LOGGER.debugf("Product version %s doesn't match!", productVersion);
            return false;
        }
        return true;
    }

    protected abstract String getProductNameRegex();

    protected abstract String getProductVersionRegex();

    protected abstract Server constructServer(String var1, ProductInfo var2, Path var3, MigrationEnvironment var4);
}

