/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.core;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import org.jboss.migration.core.Server;
import org.jboss.migration.core.ServerProvider;
import org.jboss.migration.core.env.MigrationEnvironment;
import org.jboss.migration.core.logger.ServerMigrationLogger;

public final class Servers {
    private static final ServiceLoader<ServerProvider> SERVER_PROVIDERS_LOADER = ServiceLoader.load(ServerProvider.class);

    private Servers() {
    }

    public static Server getServer(String migrationName, Path baseDir, MigrationEnvironment migrationEnvironment) {
        ServerMigrationLogger.ROOT_LOGGER.debugf("Retrieving server from base dir %s", baseDir);
        for (ServerProvider serverProvider : SERVER_PROVIDERS_LOADER) {
            try {
                Server server = serverProvider.getServer(migrationName, baseDir, migrationEnvironment);
                if (server != null) {
                    ServerMigrationLogger.ROOT_LOGGER.debugf("%s recognized as %s base dir. Server product info: %s", baseDir, serverProvider.getName(), server.getProductInfo());
                    return server;
                }
                ServerMigrationLogger.ROOT_LOGGER.debugf("%s not recognized as %s base dir.", baseDir, serverProvider.getName());
            }
            catch (Throwable e) {
                ServerMigrationLogger.ROOT_LOGGER.debugf(e, "Failure retrieving server from provider %s", serverProvider.getClass());
            }
        }
        ServerMigrationLogger.ROOT_LOGGER.debugf("%s not recognized as valid server base dir", baseDir);
        return null;
    }

    public static List<String> getServerProviderNames() {
        ArrayList<String> serverNames = new ArrayList<String>();
        for (ServerProvider serverProvider : SERVER_PROVIDERS_LOADER) {
            serverNames.add(serverProvider.getName());
        }
        return serverNames;
    }
}

