/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.core.task.component;

import org.jboss.migration.core.console.BasicResultHandlers;
import org.jboss.migration.core.console.UserConfirmation;
import org.jboss.migration.core.env.Environment;
import org.jboss.migration.core.env.TaskEnvironment;
import org.jboss.migration.core.logger.ServerMigrationLogger;
import org.jboss.migration.core.task.TaskContext;
import org.jboss.migration.core.task.component.BuildParameters;

public interface TaskSkipPolicy {
    public boolean isSkipped(TaskContext var1);

    public static TaskSkipPolicy skipByTaskEnvironment(String propertyNamesBase) {
        return context -> new TaskEnvironment((Environment)context.getMigrationEnvironment(), propertyNamesBase).isSkippedByEnvironment();
    }

    public static TaskSkipPolicy skipIfDefaultTaskSkipPropertyIsSet() {
        return context -> TaskSkipPolicy.skipIfAnyPropertyIsSet(context.getTaskName().getName() + ".skip").isSkipped(context);
    }

    public static TaskSkipPolicy skipIfAnyPropertyIsSet(String ... propertyNames) {
        return context -> {
            for (String propertyName : propertyNames) {
                if (!context.getMigrationEnvironment().getPropertyAsBoolean(propertyName, Boolean.FALSE).booleanValue()) continue;
                return true;
            }
            return false;
        };
    }

    public static TaskSkipPolicy skipIfAnySkips(TaskSkipPolicy ... policies) {
        return context -> {
            for (TaskSkipPolicy policy : policies) {
                if (!policy.isSkipped(context)) continue;
                return true;
            }
            return false;
        };
    }

    public static TaskSkipPolicy skipIfAllSkips(TaskSkipPolicy ... policies) {
        return context -> {
            for (TaskSkipPolicy policy : policies) {
                if (policy.isSkipped(context)) continue;
                return false;
            }
            return true;
        };
    }

    public static TaskSkipPolicy skipIfNoUserConfirmation(final String message) {
        return new TaskSkipPolicy(){

            @Override
            public boolean isSkipped(TaskContext context) {
                return !this.confirmTaskRun(context);
            }

            private boolean confirmTaskRun(TaskContext context) {
                BasicResultHandlers.UserConfirmation resultHandler = new BasicResultHandlers.UserConfirmation();
                new UserConfirmation(context.getConsoleWrapper(), message, ServerMigrationLogger.ROOT_LOGGER.yesNo(), (UserConfirmation.ResultHandler)resultHandler).execute();
                switch (resultHandler.getResult()) {
                    case NO: {
                        return false;
                    }
                    case YES: {
                        return true;
                    }
                }
                return this.confirmTaskRun(context);
            }
        };
    }

    public static interface Builders {
        public static <P extends BuildParameters> Builder<P> skipIfDefaultTaskSkipPropertyIsSet() {
            return buildParameters -> TaskSkipPolicy.skipIfDefaultTaskSkipPropertyIsSet();
        }

        public static <P extends BuildParameters> Builder<P> skipByTaskEnvironment(String taskEnvironmentPropertyNamePrefix) {
            return buildParameters -> TaskSkipPolicy.skipByTaskEnvironment(taskEnvironmentPropertyNamePrefix);
        }

        public static <P extends BuildParameters> Builder<P> skipIfAnyPropertyIsSet(String ... propertyNames) {
            return buildParameters -> TaskSkipPolicy.skipIfAnyPropertyIsSet(propertyNames);
        }

        public static <P extends BuildParameters> Builder<P> skipIfNoUserConfirmation(String message) {
            return buildParameters -> TaskSkipPolicy.skipIfNoUserConfirmation(message);
        }

        public static <P extends BuildParameters> Builder<P> skipIfAnySkips(Builder<P> ... builders) {
            return buildParameters -> context -> {
                for (Builder builder : builders) {
                    if (!builder.build(buildParameters).isSkipped(context)) continue;
                    return true;
                }
                return false;
            };
        }

        public static <P extends BuildParameters> Builder<P> skipIfAllSkips(Builder<P> ... builders) {
            return buildParameters -> context -> {
                for (Builder builder : builders) {
                    if (builder.build(buildParameters).isSkipped(context)) continue;
                    return false;
                }
                return true;
            };
        }
    }

    public static interface Builder<P extends BuildParameters> {
        public TaskSkipPolicy build(P var1);
    }
}

