/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.wfly13.task.subsystem.elytron;

import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.client.helpers.Operations;
import org.jboss.migration.wfly10.config.management.HostConfiguration;
import org.jboss.migration.wfly10.config.management.HostControllerConfiguration;
import org.jboss.migration.wfly10.config.management.ManageableServerConfiguration;
import org.jboss.migration.wfly10.config.management.ManageableServerConfigurationType;
import org.jboss.migration.wfly10.config.management.StandaloneServerConfiguration;
import org.jboss.migration.wfly11.task.subsystem.elytron.AddElytronSubsystemConfig;
import org.jboss.migration.wfly11.task.subsystem.elytron.ConstantRealmMapperAddOperation;
import org.jboss.migration.wfly11.task.subsystem.elytron.ConstantRoleMapperAddOperation;
import org.jboss.migration.wfly11.task.subsystem.elytron.Permission;
import org.jboss.migration.wfly11.task.subsystem.elytron.SecurityDomainAddOperation;
import org.jboss.migration.wfly11.task.subsystem.elytron.SimpleRoleDecoderAddOperation;
import org.jboss.migration.wfly13.task.subsystem.elytron.PermissionSet;
import org.jboss.migration.wfly13.task.subsystem.elytron.PermissionSetAddOperation;
import org.jboss.migration.wfly13.task.subsystem.elytron.PermissionSetMapping;
import org.jboss.migration.wfly13.task.subsystem.elytron.SimplePermissionMapperAddOperationV3;

public class WildFly13_0AddElytronSubsystemConfig<S>
extends AddElytronSubsystemConfig<S> {
    protected void addOperationSteps(ManageableServerConfiguration configuration, PathAddress subsystemPathAddress, Operations.CompositeOperationBuilder compositeOperationBuilder) {
        super.addOperationSteps(configuration, subsystemPathAddress, compositeOperationBuilder);
        this.addPermissionSets(configuration, subsystemPathAddress, compositeOperationBuilder);
    }

    protected void addSecurityDomains(ManageableServerConfiguration configuration, PathAddress subsystemPathAddress, Operations.CompositeOperationBuilder compositeOperationBuilder) {
        ManageableServerConfigurationType configurationType = configuration.getConfigurationType();
        if (configurationType == StandaloneServerConfiguration.RESOURCE_TYPE || configurationType == HostControllerConfiguration.RESOURCE_TYPE) {
            SecurityDomainAddOperation securityDomainAddOperation = new SecurityDomainAddOperation(subsystemPathAddress, "ApplicationDomain").permissionMapper("default-permission-mapper").defaultRealm("ApplicationRealm").addRealm(new SecurityDomainAddOperation.Realm("ApplicationRealm").roleDecoder("groups-to-roles"));
            if (configurationType == StandaloneServerConfiguration.RESOURCE_TYPE) {
                securityDomainAddOperation.addRealm(new SecurityDomainAddOperation.Realm("local"));
            }
            compositeOperationBuilder.addStep(securityDomainAddOperation.toModelNode());
        }
        if (configurationType == StandaloneServerConfiguration.RESOURCE_TYPE || configurationType == HostConfiguration.RESOURCE_TYPE) {
            compositeOperationBuilder.addStep(new SecurityDomainAddOperation(subsystemPathAddress, "ManagementDomain").permissionMapper("default-permission-mapper").defaultRealm("ManagementRealm").addRealm(new SecurityDomainAddOperation.Realm("ManagementRealm").roleDecoder("groups-to-roles")).addRealm(new SecurityDomainAddOperation.Realm("local").roleMapper("super-user-mapper")).toModelNode());
        }
    }

    protected void addMappers(ManageableServerConfiguration configuration, PathAddress subsystemPathAddress, Operations.CompositeOperationBuilder compositeOperationBuilder) {
        PermissionSetMapping anonymousPermissionMapping = new PermissionSetMapping().addPrincipal("anonymous").addPermissionSet(new PermissionSet("default-permissions"));
        PermissionSetMapping matchAllPermissionMapping = new PermissionSetMapping().matchAll(true).addPermissionSet(new PermissionSet("login-permission")).addPermissionSet(new PermissionSet("default-permissions"));
        compositeOperationBuilder.addStep(new SimplePermissionMapperAddOperationV3(subsystemPathAddress, "default-permission-mapper").mappingMode("first").addPermissionSetMapping(anonymousPermissionMapping).addPermissionSetMapping(matchAllPermissionMapping).toModelNode());
        compositeOperationBuilder.addStep(new ConstantRealmMapperAddOperation(subsystemPathAddress, "local").realmName("local").toModelNode());
        compositeOperationBuilder.addStep(new SimpleRoleDecoderAddOperation(subsystemPathAddress, "groups-to-roles").attribute("groups").toModelNode());
        compositeOperationBuilder.addStep(new ConstantRoleMapperAddOperation(subsystemPathAddress, "super-user-mapper").addRole("SuperUser").toModelNode());
    }

    protected void addPermissionSets(ManageableServerConfiguration configuration, PathAddress subsystemPathAddress, Operations.CompositeOperationBuilder compositeOperationBuilder) {
        ManageableServerConfigurationType configurationType = configuration.getConfigurationType();
        PermissionSetAddOperation loginPermissionSetAddOperation = new PermissionSetAddOperation(subsystemPathAddress, "login-permission").addPermission(new Permission("org.wildfly.security.auth.permission.LoginPermission"));
        compositeOperationBuilder.addStep(loginPermissionSetAddOperation.toModelNode());
        PermissionSetAddOperation defaultPermissionsSetAddOperation = new PermissionSetAddOperation(subsystemPathAddress, "default-permissions");
        if (configurationType == StandaloneServerConfiguration.RESOURCE_TYPE || configurationType == HostControllerConfiguration.RESOURCE_TYPE) {
            defaultPermissionsSetAddOperation.addPermission(new Permission("org.wildfly.extension.batch.jberet.deployment.BatchPermission").module("org.wildfly.extension.batch.jberet").targetName("*")).addPermission(new Permission("org.wildfly.transaction.client.RemoteTransactionPermission").module("org.wildfly.transaction.client")).addPermission(new Permission("org.jboss.ejb.client.RemoteEJBPermission").module("org.jboss.ejb-client"));
        }
        compositeOperationBuilder.addStep(defaultPermissionsSetAddOperation.toModelNode());
    }
}

