/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.eap.task.subsystem.transactions;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.jboss.migration.core.ServerMigrationFailureException;
import org.jboss.migration.core.jboss.JBossServer;
import org.jboss.migration.core.jboss.JBossServerConfiguration;
import org.jboss.migration.core.task.ServerMigrationTask;
import org.jboss.migration.core.task.ServerMigrationTaskResult;
import org.jboss.migration.core.task.TaskContext;
import org.jboss.migration.core.task.component.SimpleComponentTask;
import org.jboss.migration.core.task.component.TaskSkipPolicy;
import org.jboss.migration.core.util.xml.XMLFileFilter;
import org.jboss.migration.core.util.xml.XMLFiles;
import org.jboss.migration.wfly10.config.task.ServerConfigurationMigration;

public class UpdateObjectStorePath<S extends JBossServer<S>>
implements ServerConfigurationMigration.XMLConfigurationSubtaskFactory<JBossServerConfiguration<S>> {
    public static final String TASK_NAME = "subsystem.transactions.update-xml-object-store-paths";

    public ServerMigrationTask getTask(JBossServerConfiguration<S> source, JBossServerConfiguration targetConfigurationPath) {
        return ((SimpleComponentTask.Builder)((SimpleComponentTask.Builder)((SimpleComponentTask.Builder)new SimpleComponentTask.Builder().name(TASK_NAME)).skipPolicy(TaskSkipPolicy.skipIfDefaultTaskSkipPropertyIsSet())).runnable(context -> {
            context.getLogger().debugf("Searching for transactions subsystem XML configurations with deprecated object store paths, not supported by the target server...", new Object[0]);
            ServerMigrationTaskResult taskResult = this.processXMLConfiguration(source, targetConfigurationPath, context);
            if (taskResult.getStatus() == ServerMigrationTaskResult.Status.SKIPPED) {
                context.getLogger().debugf("No transactions subsystem XML configurations found with deprecated object store paths.", new Object[0]);
            } else {
                context.getLogger().infof("Subsystem transactions XML updated.", new Object[0]);
            }
            return taskResult;
        })).build();
    }

    protected ServerMigrationTaskResult processXMLConfiguration(JBossServerConfiguration<S> source, JBossServerConfiguration targetConfigurationPath, TaskContext context) {
        Boolean updated = false;
        ServerMigrationTaskResult.Builder taskResultBuilder = new ServerMigrationTaskResult.Builder().skipped();
        XMLFileFilter extensionsFilter = (startElement, xmlEventReader, xmlEventWriter, xmlEventFactory) -> {
            if (startElement.getName().getLocalPart().equals("subsystem") && startElement.getName().getNamespaceURI().startsWith("urn:jboss:domain:transactions:")) {
                try {
                    xmlEventWriter.add(startElement);
                    if (this.processSubsystemXMLConfiguration(xmlEventReader, xmlEventWriter, xmlEventFactory)) {
                        taskResultBuilder.success();
                    }
                }
                catch (Throwable e) {
                    throw new ServerMigrationFailureException(e);
                }
                return XMLFileFilter.Result.CONTINUE;
            }
            return XMLFileFilter.Result.NOT_APPLICABLE;
        };
        XMLFiles.filter((Path)targetConfigurationPath.getPath(), (XMLFileFilter[])new XMLFileFilter[]{extensionsFilter});
        return taskResultBuilder.build();
    }

    protected boolean processSubsystemXMLConfiguration(XMLEventReader xmlEventReader, XMLEventWriter xmlEventWriter, XMLEventFactory xmlEventFactory) throws XMLStreamException {
        boolean updated = false;
        String path = null;
        String relativeTo = null;
        while (xmlEventReader.hasNext()) {
            XMLEvent xmlEvent = xmlEventReader.nextEvent();
            if (xmlEvent.isStartElement()) {
                StartElement startElement = xmlEvent.asStartElement();
                QName qName = startElement.getName();
                if (qName.getLocalPart().equals("core-environment")) {
                    ArrayList<Attribute> attributes = new ArrayList<Attribute>();
                    Iterator<Attribute> iterator = startElement.getAttributes();
                    while (iterator.hasNext()) {
                        Attribute attribute = iterator.next();
                        if (attribute.getName().getLocalPart().equals("path")) {
                            path = attribute.getValue();
                            continue;
                        }
                        if (attribute.getName().getLocalPart().equals("relative-to")) {
                            relativeTo = attribute.getValue();
                            continue;
                        }
                        attributes.add(attribute);
                    }
                    StartElement startElementToWrite = path != null || relativeTo != null ? xmlEventFactory.createStartElement(qName, attributes.iterator(), startElement.getNamespaces()) : startElement;
                    this.writeElement(startElementToWrite, xmlEventReader, xmlEventWriter);
                    continue;
                }
                if (updated) {
                    this.writeElement(startElement, xmlEventReader, xmlEventWriter);
                    continue;
                }
                if (path == null && relativeTo == null) {
                    this.writeElement(startElement, xmlEventReader, xmlEventWriter);
                    continue;
                }
                if (qName.getLocalPart().equals("object-store")) {
                    this.writeElement(startElement, xmlEventReader, xmlEventWriter);
                    updated = true;
                    continue;
                }
                if (qName.getLocalPart().equals("jts") || qName.getLocalPart().equals("use-hornetq-store") || qName.getLocalPart().equals("jdbc-store") || qName.getLocalPart().equals("commit-markable-resources")) {
                    this.writeNewObjectStoreElement(path, relativeTo, qName, startElement.getNamespaces(), xmlEventWriter, xmlEventFactory);
                    updated = true;
                    this.writeElement(startElement, xmlEventReader, xmlEventWriter);
                    continue;
                }
                this.writeElement(startElement, xmlEventReader, xmlEventWriter);
                continue;
            }
            if (xmlEvent.isEndElement()) {
                EndElement endElement = xmlEvent.asEndElement();
                if (!(updated || path == null && relativeTo == null)) {
                    this.writeNewObjectStoreElement(path, relativeTo, endElement.getName(), endElement.getNamespaces(), xmlEventWriter, xmlEventFactory);
                    updated = true;
                }
                xmlEventWriter.add(xmlEvent);
                return updated;
            }
            xmlEventWriter.add(xmlEvent);
        }
        throw new IllegalStateException();
    }

    protected void writeElement(StartElement startElement, XMLEventReader xmlEventReader, XMLEventWriter xmlEventWriter) throws XMLStreamException {
        xmlEventWriter.add(startElement);
        int endElementsLeft = 1;
        do {
            XMLEvent xmlEvent;
            if ((xmlEvent = xmlEventReader.nextEvent()).isStartElement()) {
                ++endElementsLeft;
            } else if (xmlEvent.isEndElement()) {
                --endElementsLeft;
            }
            xmlEventWriter.add(xmlEvent);
        } while (xmlEventReader.hasNext() && endElementsLeft > 0);
    }

    protected void writeNewObjectStoreElement(String path, String relativeTo, QName currentElementQName, Iterator currentElementNamespaces, XMLEventWriter xmlEventWriter, XMLEventFactory xmlEventFactory) throws XMLStreamException {
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        if (path != null) {
            attributes.add(xmlEventFactory.createAttribute("path", path));
        }
        if (relativeTo != null) {
            attributes.add(xmlEventFactory.createAttribute("relative-to", relativeTo));
        }
        QName objectStoreQName = currentElementQName.getPrefix() == null ? new QName(currentElementQName.getNamespaceURI(), "object-store") : new QName(currentElementQName.getNamespaceURI(), "object-store", currentElementQName.getPrefix());
        xmlEventWriter.add(xmlEventFactory.createStartElement(objectStoreQName, attributes.iterator(), currentElementNamespaces));
        xmlEventWriter.add(xmlEventFactory.createEndElement(objectStoreQName, currentElementNamespaces));
    }
}

