/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.wfly10.config.task;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.migration.core.task.ServerMigrationTask;
import org.jboss.migration.core.task.ServerMigrationTaskName;
import org.jboss.migration.core.task.ServerMigrationTaskResult;
import org.jboss.migration.wfly10.config.management.HostConfiguration;
import org.jboss.migration.wfly10.config.management.HostControllerConfiguration;
import org.jboss.migration.wfly10.config.management.HostResource;
import org.jboss.migration.wfly10.config.management.ManageableResource;
import org.jboss.migration.wfly10.config.management.impl.EmbeddedHostConfiguration;
import org.jboss.migration.wfly10.config.task.factory.HostConfigurationTaskFactory;
import org.jboss.migration.wfly10.config.task.factory.HostsManagementTaskFactory;
import org.jboss.migration.wfly10.config.task.factory.ManageableServerConfigurationTaskFactory;
import org.jboss.migration.wfly10.config.task.management.configuration.ManageableServerConfigurationComponentTaskBuilder;
import org.jboss.migration.wfly10.config.task.management.resource.ManageableResourceBuildParametersImpl;
import org.jboss.migration.wfly10.config.task.management.resource.ManageableResourceComponentTaskBuilder;
import org.jboss.migration.wfly10.config.task.management.resource.ManageableResourceCompositeSubtasks;
import org.jboss.migration.wfly10.config.task.management.resource.ManageableResourceCompositeTask;
import org.jboss.migration.wfly10.config.task.management.resource.ManageableResourceLeafTask;
import org.jboss.migration.wfly10.config.task.management.resources.ManageableResourcesComponentTaskBuilder;

public class HostMigration<S>
implements HostsManagementTaskFactory<S> {
    public static final String HOSTS = "hosts";
    public static final String HOST = "host";
    public static final String MIGRATION_REPORT_TASK_ATTR_NAME = "name";
    protected final HostConfigurationProvider hostConfigurationProvider;
    protected final List<HostConfigurationTaskFactory<S>> subtaskFactories;

    protected HostMigration(Builder<S> builder) {
        this.hostConfigurationProvider = ((Builder)builder).hostConfigurationProvider;
        this.subtaskFactories = Collections.unmodifiableList(((Builder)builder).subtaskFactories);
    }

    @Override
    public ServerMigrationTask getTask(S source, HostResource.Parent hostsManagement) {
        return ((ManageableResourceCompositeTask.Builder)((ManageableResourceCompositeTask.Builder)((ManageableResourceCompositeTask.Builder)((ManageableResourceCompositeTask.Builder)new ManageableResourceCompositeTask.Builder().name(HOSTS)).beforeRun(context -> context.getLogger().infof("Hosts migration starting...", new Object[0]))).subtasks(new ManageableResourceCompositeSubtasks.Builder().subtask(HostResource.class, this.getSubtask()))).afterRun(context -> context.getLogger().infof("Hosts migration done.", new Object[0]))).build(new ManageableResourceBuildParametersImpl<S, HostResource.Parent>(source, hostsManagement));
    }

    protected ManageableResourceComponentTaskBuilder<S, HostResource, ?> getSubtask() {
        return (ManageableResourceComponentTaskBuilder)((ManageableResourceLeafTask.Builder)((ManageableResourceLeafTask.Builder)((ManageableResourceLeafTask.Builder)new ManageableResourceLeafTask.Builder().nameBuilder(parameters -> new ServerMigrationTaskName.Builder(HOST).addAttribute(MIGRATION_REPORT_TASK_ATTR_NAME, ((HostResource)parameters.getResource()).getResourceName()).build())).beforeRunBuilder(parameters -> context -> {
            context.getConsoleWrapper().printf("%n%n", new Object[0]);
            context.getLogger().infof("Migrating host %s in host configuration %s ...", (Object)((HostResource)parameters.getResource()).getResourceName(), parameters.getSource());
        })).afterRunBuilder(parameters -> context -> context.getLogger().infof("Migration of host %s in host configuration %s done.", (Object)((HostResource)parameters.getResource()).getResourceName(), parameters.getSource()))).runBuilder(params -> context -> {
            HostConfiguration hostConfiguration = this.hostConfigurationProvider.getHostConfiguration(((HostResource)params.getResource()).getResourceName(), (HostControllerConfiguration)((HostResource)params.getResource()).getServerConfiguration());
            hostConfiguration.start();
            try {
                for (HostConfigurationTaskFactory subtaskFactory : this.subtaskFactories) {
                    ServerMigrationTask subtask = subtaskFactory.getTask(params.getSource(), hostConfiguration);
                    if (subtask == null) continue;
                    context.execute(subtask);
                }
            }
            finally {
                hostConfiguration.stop();
            }
            return context.hasSucessfulSubtasks() ? ServerMigrationTaskResult.SUCCESS : ServerMigrationTaskResult.SKIPPED;
        });
    }

    public static class Builder<S> {
        private HostConfigurationProvider hostConfigurationProvider;
        private final List<HostConfigurationTaskFactory<S>> subtaskFactories;

        public Builder() {
            this(new EmbeddedHostConfiguration.HostConfigFileMigrationFactory());
        }

        public Builder(HostConfigurationProvider hostConfigurationProvider) {
            this.hostConfigurationProvider = hostConfigurationProvider;
            this.subtaskFactories = new ArrayList<HostConfigurationTaskFactory<S>>();
        }

        public Builder<S> subtask(HostConfigurationTaskFactory<S> subtaskFactory) {
            this.subtaskFactories.add(subtaskFactory);
            return this;
        }

        public Builder<S> subtask(ManageableServerConfigurationComponentTaskBuilder<S, ?> subtaskBuilder) {
            return this.subtask(ManageableServerConfigurationTaskFactory.of(subtaskBuilder));
        }

        public Builder<S> subtask(ManageableResourceComponentTaskBuilder<S, ManageableResource, ?> subtaskBuilder) {
            return this.subtask(ManageableServerConfigurationTaskFactory.of(subtaskBuilder));
        }

        public Builder<S> subtask(ManageableResourcesComponentTaskBuilder<S, ManageableResource, ?> subtaskBuilder) {
            return this.subtask(ManageableServerConfigurationTaskFactory.of(subtaskBuilder));
        }

        public Builder<S> subtask(final ManageableServerConfigurationTaskFactory<S, HostConfiguration> subtaskFactory) {
            return this.subtask(new HostConfigurationTaskFactory<S>(){

                @Override
                public ServerMigrationTask getTask(S source, HostConfiguration configuration) {
                    return subtaskFactory.getTask(source, configuration);
                }
            });
        }

        public HostMigration<S> build() {
            return new HostMigration(this);
        }
    }

    public static interface HostConfigurationProvider {
        public HostConfiguration getHostConfiguration(String var1, HostControllerConfiguration var2);
    }
}

