/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.wfly10.config.task.subsystem.infinispan;

import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.client.helpers.Operations;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.dmr.ModelNode;
import org.jboss.migration.core.env.TaskEnvironment;
import org.jboss.migration.core.task.ServerMigrationTaskResult;
import org.jboss.migration.core.task.TaskContext;
import org.jboss.migration.wfly10.config.management.ManageableServerConfiguration;
import org.jboss.migration.wfly10.config.management.SubsystemResource;
import org.jboss.migration.wfly10.config.task.management.subsystem.UpdateSubsystemResourceSubtaskBuilder;

public class AddServerCache<S>
extends UpdateSubsystemResourceSubtaskBuilder<S> {
    public static final String TASK_NAME = "add-infinispan-server-cache";
    private static final String CACHE_CONTAINER = "cache-container";
    private static final String CACHE_NAME = "server";
    private static final String DEFAULT_CACHE_ATTR_NAME = "default-cache";
    private static final String DEFAULT_CACHE_ATTR_VALUE = "default";
    private static final String MODULE_ATTR_NAME = "module";
    private static final String MODULE_ATTR_VALUE = "org.wildfly.clustering.server";
    private static final String LOCAL_CACHE = "local-cache";
    private static final String LOCAL_CACHE_NAME = "default";
    private static final String COMPONENT = "component";
    private static final String COMPONENT_NAME = "transaction";
    private static final String MODE_ATTR_NAME = "mode";
    private static final String MODE_ATTR_VALUE = "BATCH";

    public AddServerCache() {
        this.subtaskName(TASK_NAME);
    }

    @Override
    protected ServerMigrationTaskResult updateConfiguration(ModelNode config, S source, SubsystemResource subsystemResource, TaskContext context, TaskEnvironment taskEnvironment) {
        if (!config.hasDefined(CACHE_CONTAINER)) {
            context.getLogger().infof("No Cache container", new Object[0]);
            return ServerMigrationTaskResult.SKIPPED;
        }
        if (config.hasDefined(new String[]{CACHE_CONTAINER, CACHE_NAME})) {
            return ServerMigrationTaskResult.SKIPPED;
        }
        PathAddress subsystemPathAddress = subsystemResource.getResourcePathAddress();
        ManageableServerConfiguration configurationManagement = subsystemResource.getServerConfiguration();
        Operations.CompositeOperationBuilder compositeOperationBuilder = Operations.CompositeOperationBuilder.create();
        PathAddress cachePathAddress = subsystemPathAddress.append(new PathElement[]{PathElement.pathElement((String)CACHE_CONTAINER, (String)CACHE_NAME)});
        ModelNode cacheAddOperation = Util.createAddOperation((PathAddress)cachePathAddress);
        cacheAddOperation.get(DEFAULT_CACHE_ATTR_NAME).set("default");
        cacheAddOperation.get(MODULE_ATTR_NAME).set(MODULE_ATTR_VALUE);
        compositeOperationBuilder.addStep(cacheAddOperation);
        PathAddress localCachePathAddress = cachePathAddress.append(LOCAL_CACHE, "default");
        ModelNode localCacheAddOperation = Util.createAddOperation((PathAddress)localCachePathAddress);
        compositeOperationBuilder.addStep(localCacheAddOperation);
        PathAddress localCacheTransactionPathAddress = localCachePathAddress.append(COMPONENT, COMPONENT_NAME);
        ModelNode localCacheTransactionAddOperation = Util.createAddOperation((PathAddress)localCacheTransactionPathAddress);
        localCacheTransactionAddOperation.get(MODE_ATTR_NAME).set(MODE_ATTR_VALUE);
        compositeOperationBuilder.addStep(localCacheTransactionAddOperation);
        configurationManagement.executeManagementOperation(compositeOperationBuilder.build().getOperation());
        context.getLogger().infof("Server cache added to Infinispan subsystem configuration.", new Object[0]);
        return ServerMigrationTaskResult.SUCCESS;
    }
}

