/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.wfly10.config.task.update;

import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ValueExpression;
import org.jboss.migration.core.task.ServerMigrationTaskName;
import org.jboss.migration.core.task.ServerMigrationTaskResult;
import org.jboss.migration.core.task.component.TaskSkipPolicy;
import org.jboss.migration.wfly10.config.management.InterfaceResource;
import org.jboss.migration.wfly10.config.task.management.configuration.ManageableServerConfigurationCompositeTask;
import org.jboss.migration.wfly10.config.task.management.resource.ManageableResourceCompositeSubtasks;
import org.jboss.migration.wfly10.config.task.management.resource.ManageableResourceLeafTask;
import org.jboss.migration.wfly10.config.task.management.resource.ManageableResourceTaskRunnableBuilder;

public class UpdateUnsecureInterface<S>
extends ManageableServerConfigurationCompositeTask.Builder<S> {
    private static final String INTERFACE_NAME = "unsecure";
    private static final ServerMigrationTaskName TASK_NAME = new ServerMigrationTaskName.Builder("interface.unsecure.update").build();

    public UpdateUnsecureInterface() {
        this.name(TASK_NAME);
        this.skipPolicy(TaskSkipPolicy.skipIfDefaultTaskSkipPropertyIsSet());
        this.beforeRun(context -> context.getLogger().infof("Unsecure interface update task starting...", new Object[0]));
        this.subtasks(InterfaceResource.class, INTERFACE_NAME, ManageableResourceCompositeSubtasks.of(new SetUnsecureInterfaceInetAddress()));
        this.afterRun(context -> context.getLogger().debugf("Unsecure interface update task done.", new Object[0]));
    }

    static /* synthetic */ ServerMigrationTaskName access$000() {
        return TASK_NAME;
    }

    public static class SetUnsecureInterfaceInetAddress<S>
    extends ManageableResourceLeafTask.Builder<S, InterfaceResource> {
        private static final ServerMigrationTaskName SUBTASK_NAME = new ServerMigrationTaskName.Builder(UpdateUnsecureInterface.access$000().getName() + ".set-inet-address").build();

        protected SetUnsecureInterfaceInetAddress() {
            this.name(SUBTASK_NAME);
            this.skipPolicy(TaskSkipPolicy.skipIfDefaultTaskSkipPropertyIsSet());
            ManageableResourceTaskRunnableBuilder runnableBuilder = params -> context -> {
                InterfaceResource resource = (InterfaceResource)params.getResource();
                ModelNode resourceConfig = ((InterfaceResource)params.getResource()).getResourceConfiguration();
                if (resourceConfig == null) {
                    context.getLogger().debugf("Interface %s does not exists.", (Object)UpdateUnsecureInterface.INTERFACE_NAME);
                    return ServerMigrationTaskResult.SKIPPED;
                }
                if (resourceConfig.hasDefined("inet-address")) {
                    context.getLogger().debugf("Interface %s inet address already defined.", (Object)UpdateUnsecureInterface.INTERFACE_NAME);
                    return ServerMigrationTaskResult.SKIPPED;
                }
                ValueExpression valueExpression = new ValueExpression("${jboss.bind.address.unsecure:127.0.0.1}");
                PathAddress pathAddress = resource.getResourcePathAddress();
                ModelNode writeAttrOp = Util.createEmptyOperation((String)"write-attribute", (PathAddress)pathAddress);
                writeAttrOp.get("name").set("inet-address");
                writeAttrOp.get("value").set(valueExpression);
                resource.getServerConfiguration().executeManagementOperation(writeAttrOp);
                context.getLogger().infof("Interface %s inet address value set as %s.", (Object)UpdateUnsecureInterface.INTERFACE_NAME, (Object)valueExpression.getExpressionString());
                return ServerMigrationTaskResult.SUCCESS;
            };
            this.runBuilder(runnableBuilder);
        }
    }
}

