/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.wfly10.config.task.update;

import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.dmr.ModelNode;
import org.jboss.migration.core.task.ServerMigrationTaskName;
import org.jboss.migration.core.task.ServerMigrationTaskResult;
import org.jboss.migration.core.task.component.TaskSkipPolicy;
import org.jboss.migration.wfly10.config.management.JvmResource;
import org.jboss.migration.wfly10.config.task.management.configuration.ManageableServerConfigurationCompositeTask;
import org.jboss.migration.wfly10.config.task.management.resource.ManageableResourceCompositeSubtasks;
import org.jboss.migration.wfly10.config.task.management.resource.ManageableResourceLeafTask;
import org.jboss.migration.wfly10.config.task.management.resource.ManageableResourceTaskRunnableBuilder;

public class RemovePermgenAttributesFromJVMConfigs<S>
extends ManageableServerConfigurationCompositeTask.Builder<S> {
    public RemovePermgenAttributesFromJVMConfigs() {
        this.name("jvms.remove-permgen-attributes");
        this.skipPolicy(TaskSkipPolicy.skipIfDefaultTaskSkipPropertyIsSet());
        this.beforeRun(context -> context.getLogger().debugf("Removing JVM's permgen attributes...", new Object[0]));
        this.afterRun(context -> {
            if (context.hasSucessfulSubtasks()) {
                context.getLogger().infof("JVM's permgen attributes removed.", new Object[0]);
            }
        });
        this.subtasks(JvmResource.class, ManageableResourceCompositeSubtasks.of(new Subtask()));
    }

    public static class Subtask<S>
    extends ManageableResourceLeafTask.Builder<S, JvmResource> {
        protected Subtask() {
            this.nameBuilder(parameters -> new ServerMigrationTaskName.Builder("jvm." + ((JvmResource)parameters.getResource()).getResourceName() + ".remove-permgen-attributes").build());
            ManageableResourceTaskRunnableBuilder runnableBuilder = params -> context -> {
                ModelNode op;
                JvmResource resource = (JvmResource)params.getResource();
                ModelNode config = resource.getResourceConfiguration();
                PathAddress pathAddress = resource.getResourcePathAddress();
                boolean updated = false;
                if (config.hasDefined("permgen-size")) {
                    op = Util.getUndefineAttributeOperation((PathAddress)pathAddress, (String)"permgen-size");
                    resource.getServerConfiguration().executeManagementOperation(op);
                    updated = true;
                }
                if (config.hasDefined("max-permgen-size")) {
                    op = Util.getUndefineAttributeOperation((PathAddress)pathAddress, (String)"max-permgen-size");
                    resource.getServerConfiguration().executeManagementOperation(op);
                    updated = true;
                }
                if (!updated) {
                    return ServerMigrationTaskResult.SKIPPED;
                }
                context.getLogger().debugf("JVM %s permgen attributes removed.", (Object)resource.getResourceAbsoluteName());
                return ServerMigrationTaskResult.SUCCESS;
            };
            this.runBuilder(runnableBuilder);
        }
    }
}

