/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.wfly10.config.task.update;

import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.dmr.ModelNode;
import org.jboss.migration.core.task.ServerMigrationTaskResult;
import org.jboss.migration.core.task.component.TaskRunnable;
import org.jboss.migration.core.task.component.TaskSkipPolicy;
import org.jboss.migration.wfly10.config.management.ManageableServerConfiguration;
import org.jboss.migration.wfly10.config.management.SecurityRealmResource;
import org.jboss.migration.wfly10.config.management.StandaloneServerConfiguration;
import org.jboss.migration.wfly10.config.task.management.configuration.ManageableServerConfigurationLeafTask;
import org.jboss.migration.wfly10.config.task.management.resource.ManageableResourceBuildParameters;
import org.jboss.migration.wfly10.config.task.management.resource.ManageableResourceTaskRunnableBuilder;

public class AddApplicationRealmSSLServerIdentity<S>
extends ManageableServerConfigurationLeafTask.Builder<S> {
    private static final String RESOURCE_NAME = "ApplicationRealm";
    public static final String SERVER_IDENTITY_NAME = "ssl";

    public AddApplicationRealmSSLServerIdentity() {
        this.name("security-realm.ApplicationRealm.add-ssl-server-identity");
        this.skipPolicy(TaskSkipPolicy.skipIfDefaultTaskSkipPropertyIsSet());
        this.beforeRun(context -> context.getLogger().debugf("Configuring security realm %s SSL server identity...", (Object)RESOURCE_NAME));
        this.runBuilder(SecurityRealmResource.class, RESOURCE_NAME, new RunnableBuilder());
        this.afterRun(context -> context.getLogger().infof("Security realm %s SSL server identity configured.", (Object)RESOURCE_NAME));
    }

    protected static class RunnableBuilder<S>
    implements ManageableResourceTaskRunnableBuilder<S, SecurityRealmResource> {
        protected RunnableBuilder() {
        }

        public TaskRunnable build(ManageableResourceBuildParameters<S, SecurityRealmResource> params) {
            return context -> {
                ManageableServerConfiguration serverConfiguration = params.getServerConfiguration();
                SecurityRealmResource resource = (SecurityRealmResource)params.getResource();
                ModelNode resourceConfig = resource.getResourceConfiguration();
                if (resourceConfig.hasDefined(new String[]{"server-identity", AddApplicationRealmSSLServerIdentity.SERVER_IDENTITY_NAME})) {
                    context.getLogger().debugf("Security realm %s already includes SSL server identify, skipping task to add it.", (Object)AddApplicationRealmSSLServerIdentity.RESOURCE_NAME);
                    return ServerMigrationTaskResult.SKIPPED;
                }
                ModelNode addOperation = Util.createAddOperation((PathAddress)resource.getResourcePathAddress().append("server-identity", AddApplicationRealmSSLServerIdentity.SERVER_IDENTITY_NAME));
                addOperation.get("keystore-path").set("application.keystore");
                String keystoreRelativeTo = serverConfiguration instanceof StandaloneServerConfiguration ? "jboss.server.config.dir" : "jboss.domain.config.dir";
                addOperation.get("keystore-relative-to").set(keystoreRelativeTo);
                addOperation.get("keystore-password").set("password");
                addOperation.get("alias").set("server");
                addOperation.get("key-password").set("password");
                addOperation.get("generate-self-signed-certificate-host").set("localhost");
                serverConfiguration.executeManagementOperation(addOperation);
                context.getLogger().debugf("SSL server identity added to security realm %s.", (Object)AddApplicationRealmSSLServerIdentity.RESOURCE_NAME);
                return ServerMigrationTaskResult.SUCCESS;
            };
        }
    }
}

