/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.wfly10;

import java.io.IOException;
import java.nio.file.Path;
import org.jboss.migration.core.AbstractServer;
import org.jboss.migration.core.ProductInfo;
import org.jboss.migration.core.Server;
import org.jboss.migration.core.ServerMigrationContext;
import org.jboss.migration.wfly10.WildFly10ServerMigration;

public abstract class WildFly10Server
extends AbstractServer {
    public WildFly10Server(ProductInfo productInfo, Path baseDir) {
        super(productInfo, baseDir);
    }

    public void migrate(Server source, ServerMigrationContext context) throws IOException {
        WildFly10ServerMigration migration = this.getMigration(source);
        if (migration == null) {
            throw new IllegalArgumentException("Source server migration to WildFly 10 not supported: " + source.getProductInfo());
        }
        migration.run(source, this, context);
    }

    protected abstract WildFly10ServerMigration getMigration(Server var1);

    public Path getStandaloneDir() {
        return this.getBaseDir().resolve("standalone");
    }

    public Path getStandaloneConfigurationDir() {
        return this.getStandaloneDir().resolve("configuration");
    }

    public Path getModulesDir() {
        return WildFly10Server.getModulesDir(this.getBaseDir());
    }

    public Path getModulesSystemLayersBaseDir() {
        return WildFly10Server.getModulesSystemLayersBaseDir(this.getBaseDir());
    }

    public static Path getModulesDir(Path baseDir) {
        return baseDir.resolve("modules");
    }

    public static Path getModulesSystemLayersBaseDir(Path baseDir) {
        return WildFly10Server.getModulesDir(baseDir).resolve("system").resolve("layers").resolve("base");
    }
}

