/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.wfly10.standalone.config;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jboss.migration.core.Server;
import org.jboss.migration.core.ServerMigrationContext;
import org.jboss.migration.core.ServerPath;
import org.jboss.migration.core.logger.ServerMigrationLogger;
import org.jboss.migration.wfly10.standalone.WildFly10StandaloneServer;
import org.jboss.migration.wfly10.subsystem.WildFly10Extension;
import org.jboss.migration.wfly10.subsystem.WildFly10Subsystem;

public class WildFly10StandaloneConfigFileSubsystemsMigration<S extends Server> {
    private final List<WildFly10Extension> supportedExtensions;
    private final List<WildFly10Subsystem> supportedSubsystems;

    public WildFly10StandaloneConfigFileSubsystemsMigration(List<WildFly10Extension> supportedExtensions) {
        this.supportedExtensions = supportedExtensions;
        this.supportedSubsystems = WildFly10StandaloneConfigFileSubsystemsMigration.getSupportedSubsystems(supportedExtensions);
    }

    private static List<WildFly10Subsystem> getSupportedSubsystems(List<WildFly10Extension> supportedExtensions) {
        ArrayList<WildFly10Subsystem> supported = new ArrayList<WildFly10Subsystem>();
        for (WildFly10Extension extension : supportedExtensions) {
            supported.addAll(extension.getSubsystems());
        }
        return Collections.unmodifiableList(supported);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(ServerPath<S> source, WildFly10StandaloneServer target, ServerMigrationContext context) throws IOException {
        context.getConsoleWrapper().printf("%n%n", new Object[0]);
        ServerMigrationLogger.ROOT_LOGGER.infof("Migrating subsystems...", new Object[0]);
        boolean targetStarted = target.isStarted();
        if (!targetStarted) {
            target.start();
        }
        try {
            Set<String> subsystems = target.getSubsystems();
            ServerMigrationLogger.ROOT_LOGGER.debugf("Subsystems found: %s", subsystems);
            this.removeUnsupportedSubsystems(target, subsystems, context);
            Set<String> extensions = target.getExtensions();
            ServerMigrationLogger.ROOT_LOGGER.debugf("Extensions found: %s", target.getExtensions());
            this.removeUnsupportedExtensions(target, extensions, context);
            this.migrateExtensions(target, extensions, context);
        }
        finally {
            if (!targetStarted) {
                target.stop();
            }
            ServerMigrationLogger.ROOT_LOGGER.info((Object)"Subsystems migration done.");
        }
    }

    protected void removeUnsupportedSubsystems(WildFly10StandaloneServer wildFly10StandaloneServer, Set<String> subsystems, ServerMigrationContext context) throws IOException {
        for (String subsystem : subsystems) {
            boolean supported = false;
            for (WildFly10Subsystem supportedSubsystem : this.supportedSubsystems) {
                if (!subsystem.equals(supportedSubsystem.getName())) continue;
                supported = true;
                break;
            }
            if (supported) continue;
            wildFly10StandaloneServer.removeSubsystem(subsystem);
            ServerMigrationLogger.ROOT_LOGGER.infof("Unsupported subsystem %s removed.", (Object)subsystem);
        }
    }

    protected void removeUnsupportedExtensions(WildFly10StandaloneServer wildFly10StandaloneServer, Set<String> extensions, ServerMigrationContext context) throws IOException {
        for (String extension : extensions) {
            boolean supported = false;
            for (WildFly10Extension supportedExtension : this.supportedExtensions) {
                if (!extension.equals(supportedExtension.getName())) continue;
                supported = true;
                break;
            }
            if (supported) continue;
            wildFly10StandaloneServer.removeExtension(extension);
            ServerMigrationLogger.ROOT_LOGGER.infof("Unsupported extension %s removed.", (Object)extension);
        }
    }

    protected void migrateExtensions(WildFly10StandaloneServer wildFly10StandaloneServer, Set<String> extensions, ServerMigrationContext context) throws IOException {
        for (WildFly10Extension supportedExtension : this.supportedExtensions) {
            supportedExtension.migrate(wildFly10StandaloneServer, context);
        }
    }
}

