/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.wfly10.standalone.config;

import java.io.IOException;
import java.util.Collection;
import org.jboss.migration.core.Server;
import org.jboss.migration.core.ServerMigrationContext;
import org.jboss.migration.core.ServerMigrationFailedException;
import org.jboss.migration.core.ServerPath;
import org.jboss.migration.core.console.UserConfirmation;
import org.jboss.migration.core.logger.ServerMigrationLogger;
import org.jboss.migration.wfly10.WildFly10Server;
import org.jboss.migration.wfly10.standalone.config.WildFly10StandaloneConfigFileMigration;

public class WildFly10StandaloneConfigFilesMigration<S extends Server> {
    private final WildFly10StandaloneConfigFileMigration configFileMigration;

    public WildFly10StandaloneConfigFilesMigration(WildFly10StandaloneConfigFileMigration configFileMigration) {
        this.configFileMigration = configFileMigration;
    }

    public void run(final Collection<ServerPath<S>> sourceConfigs, final WildFly10Server target, final ServerMigrationContext context) throws IOException {
        ServerMigrationLogger.ROOT_LOGGER.infof("Scanning for standalone server configurations...", new Object[0]);
        for (ServerPath<S> standaloneConfig : sourceConfigs) {
            ServerMigrationLogger.ROOT_LOGGER.infof("%s", standaloneConfig);
        }
        context.getConsoleWrapper().printf("%n", new Object[0]);
        if (context.isInteractive()) {
            UserConfirmation.ResultHandler resultHandler = new UserConfirmation.ResultHandler(){

                public void onNo() {
                    try {
                        WildFly10StandaloneConfigFilesMigration.this.confirmAllStandaloneConfigs(sourceConfigs, target, context);
                    }
                    catch (IOException e) {
                        throw new ServerMigrationFailedException((Throwable)e);
                    }
                }

                public void onYes() {
                    try {
                        WildFly10StandaloneConfigFilesMigration.this.migrateAllStandaloneConfigs(sourceConfigs, target, context);
                    }
                    catch (IOException e) {
                        throw new ServerMigrationFailedException((Throwable)e);
                    }
                }

                public void onError() {
                    try {
                        WildFly10StandaloneConfigFilesMigration.this.run(sourceConfigs, target, context);
                    }
                    catch (IOException e) {
                        throw new ServerMigrationFailedException((Throwable)e);
                    }
                }
            };
            new UserConfirmation(context.getConsoleWrapper(), "Migrate all configurations?", ServerMigrationLogger.ROOT_LOGGER.yesNo(), resultHandler).execute();
        } else {
            this.migrateAllStandaloneConfigs(sourceConfigs, target, context);
        }
    }

    protected void migrateAllStandaloneConfigs(Collection<ServerPath<S>> standaloneConfigs, WildFly10Server target, ServerMigrationContext context) throws IOException {
        for (ServerPath<S> sourceStandaloneConfig : standaloneConfigs) {
            this.configFileMigration.run(sourceStandaloneConfig, target, context);
        }
    }

    protected void confirmAllStandaloneConfigs(Collection<ServerPath<S>> standaloneConfigs, WildFly10Server target, ServerMigrationContext context) throws IOException {
        for (ServerPath<S> sourceStandaloneConfig : standaloneConfigs) {
            this.confirmStandaloneConfig(sourceStandaloneConfig, target, context);
        }
    }

    protected void confirmStandaloneConfig(final ServerPath<S> source, final WildFly10Server target, final ServerMigrationContext context) throws IOException {
        UserConfirmation.ResultHandler resultHandler = new UserConfirmation.ResultHandler(){

            public void onNo() {
            }

            public void onYes() {
                try {
                    WildFly10StandaloneConfigFilesMigration.this.configFileMigration.run(source, target, context);
                }
                catch (IOException e) {
                    throw new ServerMigrationFailedException((Throwable)e);
                }
            }

            public void onError() {
                try {
                    WildFly10StandaloneConfigFilesMigration.this.confirmStandaloneConfig(source, target, context);
                }
                catch (IOException e) {
                    throw new ServerMigrationFailedException((Throwable)e);
                }
            }
        };
        context.getConsoleWrapper().printf("%n", new Object[0]);
        new UserConfirmation(context.getConsoleWrapper(), "Migrate configuration " + source.getPath() + " ?", ServerMigrationLogger.ROOT_LOGGER.yesNo(), resultHandler).execute();
    }
}

