/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.wfly10.subsystem;

import java.io.IOException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.dmr.ModelNode;
import org.jboss.migration.core.ServerMigrationContext;
import org.jboss.migration.core.logger.ServerMigrationLogger;
import org.jboss.migration.wfly10.standalone.WildFly10StandaloneServer;
import org.jboss.migration.wfly10.subsystem.WildFly10Subsystem;
import org.jboss.migration.wfly10.subsystem.WildFly10SubsystemMigrationTask;

public class AddExtension
implements WildFly10SubsystemMigrationTask {
    public static final AddExtension INSTANCE = new AddExtension();

    private AddExtension() {
    }

    @Override
    public void execute(ModelNode config, WildFly10Subsystem subsystem, WildFly10StandaloneServer server, ServerMigrationContext context) throws IOException {
        String extensionName = subsystem.getExtension().getName();
        if (!server.getExtensions().contains(extensionName)) {
            ServerMigrationLogger.ROOT_LOGGER.debugf("Adding Extension %s...", (Object)extensionName);
            ModelNode op = Util.createAddOperation((PathAddress)PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"extension", (String)extensionName)}));
            op.get("module").set(extensionName);
            server.executeManagementOperation(op);
            ServerMigrationLogger.ROOT_LOGGER.infof("Extension %s added.", (Object)extensionName);
        }
    }
}

