/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.wfly10.subsystem;

import java.io.IOException;
import java.util.List;
import org.jboss.dmr.ModelNode;
import org.jboss.migration.core.ServerMigrationContext;
import org.jboss.migration.wfly10.standalone.WildFly10StandaloneServer;
import org.jboss.migration.wfly10.subsystem.WildFly10Extension;
import org.jboss.migration.wfly10.subsystem.WildFly10SubsystemMigrationTask;

public class WildFly10Subsystem {
    private final String name;
    private final WildFly10Extension extension;
    protected final List<WildFly10SubsystemMigrationTask> subsystemMigrationTasks;

    public WildFly10Subsystem(String name, List<WildFly10SubsystemMigrationTask> subsystemMigrationTasks, WildFly10Extension extension) {
        this.name = name;
        this.extension = extension;
        this.subsystemMigrationTasks = subsystemMigrationTasks;
    }

    public WildFly10Extension getExtension() {
        return this.extension;
    }

    public String getName() {
        return this.name;
    }

    public void migrate(WildFly10StandaloneServer server, ServerMigrationContext context) throws IOException {
        if (this.subsystemMigrationTasks != null && !this.subsystemMigrationTasks.isEmpty()) {
            ModelNode subsystemConfig = server.getSubsystem(this.getName());
            for (WildFly10SubsystemMigrationTask configMigrationTask : this.subsystemMigrationTasks) {
                configMigrationTask.execute(subsystemConfig, this, server, context);
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WildFly10Subsystem subsystem = (WildFly10Subsystem)o;
        return this.name.equals(subsystem.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return this.name;
    }
}

