/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.wfly10.subsystem.ee;

import java.io.IOException;
import java.util.HashMap;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.dmr.ModelNode;
import org.jboss.migration.core.ServerMigrationContext;
import org.jboss.migration.core.console.UserChoiceWithOtherOption;
import org.jboss.migration.core.logger.ServerMigrationLogger;
import org.jboss.migration.wfly10.standalone.WildFly10StandaloneServer;
import org.jboss.migration.wfly10.subsystem.WildFly10Subsystem;
import org.jboss.migration.wfly10.subsystem.WildFly10SubsystemMigrationTask;

public class AddDefaultBindingsConfig
implements WildFly10SubsystemMigrationTask {
    public static final AddDefaultBindingsConfig INSTANCE = new AddDefaultBindingsConfig();
    private static final String SERVER = "server";
    private static final String CONNECTION_FACTORY = "connection-factory";
    private static final String POOLED_CONNECTION_FACTORY = "pooled-connection-factory";
    private static final String DATA_SOURCE = "data-source";
    private static final String DATA_SOURCE_JNDI_NAME = "jndi-name";
    private static final String DEFAULT_DATASOURCE_NAME = "ExampleDS";
    private static final String DEFAULT_JMS_CONNECTION_FACTORY_NAME = "hornetq-ra";
    private static final String DEFAULT_JMS_SERVER_NAME = "default";

    private AddDefaultBindingsConfig() {
    }

    @Override
    public void execute(ModelNode config, WildFly10Subsystem subsystem, WildFly10StandaloneServer server, ServerMigrationContext context) throws IOException {
        if (config == null) {
            return;
        }
        PathAddress pathAddress = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"subsystem", (String)subsystem.getName()), PathElement.pathElement((String)"service", (String)"default-bindings")});
        ModelNode addOp = Util.createEmptyOperation((String)"add", (PathAddress)pathAddress);
        addOp.get("context-service").set("java:jboss/ee/concurrency/context/default");
        addOp.get("managed-executor-service").set("java:jboss/ee/concurrency/executor/default");
        addOp.get("managed-scheduled-executor-service").set("java:jboss/ee/concurrency/scheduler/default");
        addOp.get("managed-thread-factory").set("java:jboss/ee/concurrency/factory/default");
        this.setupDefaultDatasource(addOp, server, context);
        this.setupDefaultJMSConnectionFactory(addOp, server, context);
        server.executeManagementOperation(addOp);
        ServerMigrationLogger.ROOT_LOGGER.infof("Java EE Default Bindings configured.", new Object[0]);
    }

    private void setupDefaultJMSConnectionFactory(final ModelNode addOp, WildFly10StandaloneServer server, ServerMigrationContext context) throws IOException {
        final ModelNode subsystemConfig = server.getSubsystem("messaging-activemq");
        if (subsystemConfig == null) {
            return;
        }
        if (subsystemConfig.hasDefined(new String[]{SERVER, DEFAULT_JMS_SERVER_NAME, POOLED_CONNECTION_FACTORY, DEFAULT_JMS_CONNECTION_FACTORY_NAME})) {
            ModelNode defaultJmsConnectionFactory = subsystemConfig.get(new String[]{SERVER, DEFAULT_JMS_SERVER_NAME, POOLED_CONNECTION_FACTORY, DEFAULT_JMS_CONNECTION_FACTORY_NAME});
            String defaultJmsConnectionFactoryJndiName = ((ModelNode)defaultJmsConnectionFactory.get("entries").asList().get(0)).asString();
            addOp.get("jms-connection-factory").set(defaultJmsConnectionFactoryJndiName);
            ServerMigrationLogger.ROOT_LOGGER.infof("Default JMS Connection Factory %s found and set as the Java EE Default JMS Connection Factory.", (Object)DEFAULT_JMS_CONNECTION_FACTORY_NAME);
        } else {
            if (!context.isInteractive()) {
                ServerMigrationLogger.ROOT_LOGGER.infof("Default JMS Connection Factory not found, skipping its configuration due to non interactive mode", new Object[0]);
                return;
            }
            ServerMigrationLogger.ROOT_LOGGER.infof("Default JMS Connection Factory not found", new Object[0]);
            final HashMap<String, ConfiguredJmsConnectionFactory> factoryNamesMap = new HashMap<String, ConfiguredJmsConnectionFactory>();
            if (subsystemConfig.hasDefined(SERVER)) {
                for (String serverName : subsystemConfig.get(SERVER).keys()) {
                    ConfiguredJmsConnectionFactory configuredJmsConnectionFactory;
                    if (subsystemConfig.hasDefined(new String[]{SERVER, serverName, CONNECTION_FACTORY})) {
                        for (String factoryName : subsystemConfig.get(new String[]{SERVER, serverName, CONNECTION_FACTORY}).keys()) {
                            configuredJmsConnectionFactory = new ConfiguredJmsConnectionFactory();
                            configuredJmsConnectionFactory.serverName = serverName;
                            configuredJmsConnectionFactory.factoryType = CONNECTION_FACTORY;
                            configuredJmsConnectionFactory.factoryName = factoryName;
                            factoryNamesMap.put(configuredJmsConnectionFactory.toString(), configuredJmsConnectionFactory);
                        }
                    }
                    if (!subsystemConfig.hasDefined(new String[]{SERVER, serverName, POOLED_CONNECTION_FACTORY})) continue;
                    for (String factoryName : subsystemConfig.get(new String[]{SERVER, serverName, POOLED_CONNECTION_FACTORY}).keys()) {
                        configuredJmsConnectionFactory = new ConfiguredJmsConnectionFactory();
                        configuredJmsConnectionFactory.serverName = serverName;
                        configuredJmsConnectionFactory.factoryType = POOLED_CONNECTION_FACTORY;
                        configuredJmsConnectionFactory.factoryName = factoryName;
                        factoryNamesMap.put(configuredJmsConnectionFactory.toString(), configuredJmsConnectionFactory);
                    }
                }
            }
            String[] factoryNames = factoryNamesMap.keySet().toArray(new String[factoryNamesMap.keySet().size()]);
            UserChoiceWithOtherOption.ResultHandler resultHandler = new UserChoiceWithOtherOption.ResultHandler(){

                public void onChoice(String choice) {
                    ConfiguredJmsConnectionFactory configuredJmsConnectionFactory = (ConfiguredJmsConnectionFactory)factoryNamesMap.get(choice);
                    ModelNode jmsConnectionFactory = subsystemConfig.get(new String[]{AddDefaultBindingsConfig.SERVER, configuredJmsConnectionFactory.serverName, configuredJmsConnectionFactory.factoryType, configuredJmsConnectionFactory.factoryName});
                    String jmsConnectionFactoryJndiName = ((ModelNode)jmsConnectionFactory.get("entries").asList().get(0)).asString();
                    addOp.get("jms-connection-factory").set(jmsConnectionFactoryJndiName);
                    ServerMigrationLogger.ROOT_LOGGER.infof("JMS Connection Factory %s set as the Java EE Default JMS Connection Factory.", (Object)choice);
                }

                public void onError() {
                }

                public void onOther(String otherChoice) {
                    addOp.get("jms-connection-factory").set(otherChoice);
                    ServerMigrationLogger.ROOT_LOGGER.infof("Java EE Default JMS Connection Factory configured with JNDI name %s.", (Object)otherChoice);
                }
            };
            new UserChoiceWithOtherOption(context.getConsoleWrapper(), factoryNames, "Unconfigured JMS Connection Factory, I want to enter the JNDI name...", "Please select Java EE's Default JMS Connection Factory: ", resultHandler).execute();
        }
    }

    private void setupDefaultDatasource(final ModelNode addOp, WildFly10StandaloneServer server, ServerMigrationContext context) throws IOException {
        final ModelNode subsystemConfig = server.getSubsystem("datasources");
        if (subsystemConfig == null) {
            return;
        }
        if (subsystemConfig.hasDefined(new String[]{DATA_SOURCE, DEFAULT_DATASOURCE_NAME})) {
            ModelNode defaultDatasource = subsystemConfig.get(new String[]{DATA_SOURCE, DEFAULT_DATASOURCE_NAME});
            String defaultDatasourceJndiName = defaultDatasource.get(DATA_SOURCE_JNDI_NAME).asString();
            addOp.get("datasource").set(defaultDatasourceJndiName);
            ServerMigrationLogger.ROOT_LOGGER.infof("Default datasource %s found and set as the Java EE Default Datasource.", (Object)DEFAULT_DATASOURCE_NAME);
        } else {
            if (!context.isInteractive()) {
                ServerMigrationLogger.ROOT_LOGGER.infof("Default datasource not found, skipping its configuration due to non interactive mode", new Object[0]);
                return;
            }
            ServerMigrationLogger.ROOT_LOGGER.infof("Default datasource not found.", new Object[0]);
            String[] dataSourceNames = subsystemConfig.hasDefined(DATA_SOURCE) ? subsystemConfig.get(DATA_SOURCE).keys().toArray(new String[0]) : new String[]{};
            UserChoiceWithOtherOption.ResultHandler resultHandler = new UserChoiceWithOtherOption.ResultHandler(){

                public void onChoice(String choice) {
                    String jndiName = subsystemConfig.get(new String[]{AddDefaultBindingsConfig.DATA_SOURCE, choice}).get(AddDefaultBindingsConfig.DATA_SOURCE_JNDI_NAME).asString();
                    addOp.get("datasource").set(jndiName);
                    ServerMigrationLogger.ROOT_LOGGER.infof("Datasource %s set as the Java EE Default Datasource.", (Object)choice);
                }

                public void onError() {
                }

                public void onOther(String otherChoice) {
                    addOp.get("datasource").set(otherChoice);
                    ServerMigrationLogger.ROOT_LOGGER.infof("Java EE Default Datasource configured with JNDI name %s.", (Object)otherChoice);
                }
            };
            new UserChoiceWithOtherOption(context.getConsoleWrapper(), dataSourceNames, "Unconfigured data source, I want to enter the JNDI name...", "Please select Java EE's Default Datasource: ", resultHandler).execute();
        }
    }

    private static class ConfiguredJmsConnectionFactory {
        private String serverName;
        private String factoryType;
        private String factoryName;

        private ConfiguredJmsConnectionFactory() {
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ConfiguredJmsConnectionFactory that = (ConfiguredJmsConnectionFactory)o;
            if (!this.serverName.equals(that.serverName)) {
                return false;
            }
            if (!this.factoryType.equals(that.factoryType)) {
                return false;
            }
            return this.factoryName.equals(that.factoryName);
        }

        public int hashCode() {
            int result = this.serverName.hashCode();
            result = 31 * result + this.factoryType.hashCode();
            result = 31 * result + this.factoryName.hashCode();
            return result;
        }

        public String toString() {
            return "server = " + this.serverName + ", factory type = " + this.factoryType + ", factory name = " + this.factoryName;
        }
    }
}

