/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.wfly10.subsystem.infinispan;

import java.io.IOException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.client.helpers.Operations;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.dmr.ModelNode;
import org.jboss.migration.core.ServerMigrationContext;
import org.jboss.migration.core.logger.ServerMigrationLogger;
import org.jboss.migration.wfly10.standalone.WildFly10StandaloneServer;
import org.jboss.migration.wfly10.subsystem.WildFly10Subsystem;
import org.jboss.migration.wfly10.subsystem.WildFly10SubsystemMigrationTask;

public class AddEjbCache
implements WildFly10SubsystemMigrationTask {
    public static final AddEjbCache INSTANCE = new AddEjbCache();
    private static final String CACHE_CONTAINER = "cache-container";
    private static final String CACHE_NAME = "ejb";
    private static final String ALIASES_ATTR_NAME = "aliases";
    private static final String[] ALIASES_ATTR_VALUE = new String[]{"sfsb"};
    private static final String DEFAULT_CACHE_ATTR_NAME = "default-cache";
    private static final String DEFAULT_CACHE_ATTR_VALUE = "passivation";
    private static final String MODULE_ATTR_NAME = "module";
    private static final String MODULE_ATTR_VALUE = "org.wildfly.clustering.ejb.infinispan";
    private static final String LOCAL_CACHE = "local-cache";
    private static final String LOCAL_CACHE_NAME_PASSIVATION = "passivation";
    private static final String LOCAL_CACHE_NAME_PERSISTENCE = "persistent";
    private static final String COMPONENT = "component";
    private static final String COMPONENT_NAME_TRANSACTION = "transaction";
    private static final String MODE_ATTR_NAME = "mode";
    private static final String MODE_ATTR_VALUE_BATCH = "BATCH";
    private static final String COMPONENT_NAME_LOCKING = "locking";
    private static final String ISOLATION_ATTR_NAME = "isolation";
    private static final String ISOLATION_ATTR_VALUE_REPEATABLE_READ = "REPEATABLE_READ";
    private static final String STORE = "store";
    private static final String STORE_NAME_FILE = "file";
    private static final String PASSIVATION_ATTR_NAME = "passivation";
    private static final String PURGE_ATTR_NAME = "purge";

    private AddEjbCache() {
    }

    @Override
    public void execute(ModelNode config, WildFly10Subsystem subsystem, WildFly10StandaloneServer server, ServerMigrationContext context) throws IOException {
        if (config == null) {
            return;
        }
        if (!config.hasDefined(CACHE_CONTAINER)) {
            ServerMigrationLogger.ROOT_LOGGER.infof("No Cache container", new Object[0]);
            return;
        }
        if (config.hasDefined(new String[]{CACHE_CONTAINER, CACHE_NAME})) {
            return;
        }
        Operations.CompositeOperationBuilder compositeOperationBuilder = Operations.CompositeOperationBuilder.create();
        PathAddress cachePathAddress = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"subsystem", (String)subsystem.getName()), PathElement.pathElement((String)CACHE_CONTAINER, (String)CACHE_NAME)});
        ModelNode cacheAddOperation = Util.createAddOperation((PathAddress)cachePathAddress);
        for (String alias : ALIASES_ATTR_VALUE) {
            cacheAddOperation.get(ALIASES_ATTR_NAME).add(alias);
        }
        cacheAddOperation.get(DEFAULT_CACHE_ATTR_NAME).set("passivation");
        cacheAddOperation.get(MODULE_ATTR_NAME).set(MODULE_ATTR_VALUE);
        compositeOperationBuilder.addStep(cacheAddOperation);
        AddEjbCache.addLocalCachePassivation(compositeOperationBuilder, cachePathAddress);
        AddEjbCache.addLocalCachePersistent(compositeOperationBuilder, cachePathAddress);
        server.executeManagementOperation(compositeOperationBuilder.build().getOperation());
        ServerMigrationLogger.ROOT_LOGGER.infof("Ejb cache added to Infinispan subsystem configuration.", new Object[0]);
    }

    private static void addLocalCachePassivation(Operations.CompositeOperationBuilder compositeOperationBuilder, PathAddress cachePathAddress) {
        PathAddress localCachePathAddress = AddEjbCache.addLocalCache(compositeOperationBuilder, cachePathAddress, "passivation");
        AddEjbCache.setLocalCacheLocking(compositeOperationBuilder, localCachePathAddress, ISOLATION_ATTR_VALUE_REPEATABLE_READ);
        AddEjbCache.setLocalCacheTransaction(compositeOperationBuilder, localCachePathAddress, MODE_ATTR_VALUE_BATCH);
        AddEjbCache.setLocalCacheFileStore(compositeOperationBuilder, localCachePathAddress, true, false);
    }

    private static void addLocalCachePersistent(Operations.CompositeOperationBuilder compositeOperationBuilder, PathAddress cachePathAddress) {
        PathAddress localCachePathAddress = AddEjbCache.addLocalCache(compositeOperationBuilder, cachePathAddress, LOCAL_CACHE_NAME_PERSISTENCE);
        AddEjbCache.setLocalCacheLocking(compositeOperationBuilder, localCachePathAddress, ISOLATION_ATTR_VALUE_REPEATABLE_READ);
        AddEjbCache.setLocalCacheTransaction(compositeOperationBuilder, localCachePathAddress, MODE_ATTR_VALUE_BATCH);
        AddEjbCache.setLocalCacheFileStore(compositeOperationBuilder, localCachePathAddress, false, true);
    }

    private static PathAddress addLocalCache(Operations.CompositeOperationBuilder compositeOperationBuilder, PathAddress cachePathAddress, String localCacheName) {
        PathAddress localCachePathAddress = cachePathAddress.append(LOCAL_CACHE, localCacheName);
        ModelNode localCacheAddOperation = Util.createAddOperation((PathAddress)localCachePathAddress);
        compositeOperationBuilder.addStep(localCacheAddOperation);
        return localCachePathAddress;
    }

    private static void setLocalCacheLocking(Operations.CompositeOperationBuilder compositeOperationBuilder, PathAddress localCachePathAddress, String isolationValue) {
        PathAddress localCacheIsolationPathAddress = localCachePathAddress.append(COMPONENT, COMPONENT_NAME_LOCKING);
        ModelNode localCacheIsolationAddOperation = Util.createAddOperation((PathAddress)localCacheIsolationPathAddress);
        localCacheIsolationAddOperation.get(ISOLATION_ATTR_NAME).set(isolationValue);
        compositeOperationBuilder.addStep(localCacheIsolationAddOperation);
    }

    private static void setLocalCacheTransaction(Operations.CompositeOperationBuilder compositeOperationBuilder, PathAddress localCachePathAddress, String modeValue) {
        PathAddress localCacheTransactionPathAddress = localCachePathAddress.append(COMPONENT, COMPONENT_NAME_TRANSACTION);
        ModelNode localCacheTransactionAddOperation = Util.createAddOperation((PathAddress)localCacheTransactionPathAddress);
        localCacheTransactionAddOperation.get(MODE_ATTR_NAME).set(modeValue);
        compositeOperationBuilder.addStep(localCacheTransactionAddOperation);
    }

    private static void setLocalCacheFileStore(Operations.CompositeOperationBuilder compositeOperationBuilder, PathAddress localCachePathAddress, boolean passivation, boolean purge) {
        PathAddress localCacheFileStorePathAddress = localCachePathAddress.append(STORE, STORE_NAME_FILE);
        ModelNode localCacheFileStoreAddOperation = Util.createAddOperation((PathAddress)localCacheFileStorePathAddress);
        localCacheFileStoreAddOperation.get("passivation").set(passivation);
        localCacheFileStoreAddOperation.get(PURGE_ATTR_NAME).set(purge);
        compositeOperationBuilder.addStep(localCacheFileStoreAddOperation);
    }
}

