/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.wfly10.subsystem.infinispan;

import java.io.IOException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.dmr.ModelNode;
import org.jboss.migration.core.ServerMigrationContext;
import org.jboss.migration.core.logger.ServerMigrationLogger;
import org.jboss.migration.wfly10.standalone.WildFly10StandaloneServer;
import org.jboss.migration.wfly10.subsystem.WildFly10Subsystem;
import org.jboss.migration.wfly10.subsystem.WildFly10SubsystemMigrationTask;

public class FixHibernateCacheModuleName
implements WildFly10SubsystemMigrationTask {
    public static final FixHibernateCacheModuleName INSTANCE = new FixHibernateCacheModuleName();
    private static final String CACHE_CONTAINER = "cache-container";
    private static final String MODULE_ATTR_NAME = "module";
    private static final String MODULE_ATTR_OLD_VALUE_EAP6 = "org.jboss.as.jpa.hibernate:4";
    private static final String MODULE_ATTR_OLD_VALUE_WFLY8 = "org.hibernate";
    private static final String MODULE_ATTR_NEW_VALUE = "org.hibernate.infinispan";

    private FixHibernateCacheModuleName() {
    }

    @Override
    public void execute(ModelNode config, WildFly10Subsystem subsystem, WildFly10StandaloneServer server, ServerMigrationContext context) throws IOException {
        if (config == null) {
            return;
        }
        if (!config.hasDefined(CACHE_CONTAINER)) {
            ServerMigrationLogger.ROOT_LOGGER.infof("No Cache container", new Object[0]);
            return;
        }
        for (String cacheName : config.get(CACHE_CONTAINER).keys()) {
            ModelNode cache = config.get(new String[]{CACHE_CONTAINER, cacheName});
            if (!cache.hasDefined(MODULE_ATTR_NAME) || !cache.get(MODULE_ATTR_NAME).asString().equals(MODULE_ATTR_OLD_VALUE_EAP6) && !cache.get(MODULE_ATTR_NAME).asString().equals(MODULE_ATTR_OLD_VALUE_WFLY8)) continue;
            ModelNode op = Util.createEmptyOperation((String)"write-attribute", (PathAddress)PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"subsystem", (String)subsystem.getName()), PathElement.pathElement((String)CACHE_CONTAINER, (String)cacheName)}));
            op.get("name").set(MODULE_ATTR_NAME);
            op.get("value").set(MODULE_ATTR_NEW_VALUE);
            server.executeManagementOperation(op);
            ServerMigrationLogger.ROOT_LOGGER.infof("Infinispan subsystem's cache %s 'module' attribute updated to %s.", (Object)cacheName, (Object)MODULE_ATTR_NEW_VALUE);
        }
    }
}

