/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.wfly10.subsystem.messaging;

import java.io.IOException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.dmr.ModelNode;
import org.jboss.migration.core.ServerMigrationContext;
import org.jboss.migration.core.logger.ServerMigrationLogger;
import org.jboss.migration.wfly10.standalone.WildFly10StandaloneServer;
import org.jboss.migration.wfly10.subsystem.WildFly10Subsystem;
import org.jboss.migration.wfly10.subsystem.WildFly10SubsystemMigrationTask;

public class AddHttpAcceptorsAndConnectors
implements WildFly10SubsystemMigrationTask {
    public static final AddHttpAcceptorsAndConnectors INSTANCE = new AddHttpAcceptorsAndConnectors();
    private static final String SERVER = "server";
    private static final String SERVER_NAME = "default-server";
    private static final String HTTP_LISTENER = "http-listener";
    private static final String HTTP_LISTENER_NAME = "http";
    private static final String HTTP_ACCEPTOR = "http-acceptor";
    private static final String HTTP_ACCEPTOR_NAME = "http-acceptor";
    private static final String HTTP_ACCEPTOR_THROUGHPUT_NAME = "http-acceptor-throughput";
    private static final String HTTP_CONNECTOR = "http-connector";
    private static final String HTTP_CONNECTOR_NAME = "http-connector";
    private static final String HTTP_CONNECTOR_THROUGHPUT_NAME = "http-connector-throughput";
    private static final String SOCKET_BINDING = "socket-binding";
    private static final String SOCKET_BINDING_NAME = "http";
    private static final String ENDPOINT = "endpoint";

    private AddHttpAcceptorsAndConnectors() {
    }

    @Override
    public void execute(ModelNode config, WildFly10Subsystem subsystem, WildFly10StandaloneServer server, ServerMigrationContext context) throws IOException {
        if (config == null) {
            return;
        }
        ModelNode undertowConfig = server.getSubsystem("undertow");
        if (undertowConfig == null) {
            return;
        }
        if (!undertowConfig.hasDefined(new String[]{SERVER, SERVER_NAME, HTTP_LISTENER, "http"})) {
            ServerMigrationLogger.ROOT_LOGGER.debug((Object)"Skipping configuration of Messaging ActiveMQ http acceptors and connectors, Undertow's default HTTP listener not found.");
            return;
        }
        if (config.hasDefined(SERVER)) {
            for (String serverName : config.get(SERVER).keys()) {
                ModelNode addOp;
                PathAddress pathAddress;
                if (!config.hasDefined(new String[]{SERVER, serverName, "http-acceptor", "http-acceptor"})) {
                    pathAddress = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"subsystem", (String)subsystem.getName()), PathElement.pathElement((String)SERVER, (String)serverName), PathElement.pathElement((String)"http-acceptor", (String)"http-acceptor")});
                    addOp = Util.createEmptyOperation((String)"add", (PathAddress)pathAddress);
                    addOp.get(HTTP_LISTENER).set("http");
                    server.executeManagementOperation(addOp);
                    ServerMigrationLogger.ROOT_LOGGER.infof("HTTP Acceptor named %s added to Messaging ActiveMQ subsystem configuration.", (Object)"http-acceptor");
                }
                if (config.hasDefined(new String[]{SERVER, serverName, "http-connector", "http-connector"})) continue;
                pathAddress = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"subsystem", (String)subsystem.getName()), PathElement.pathElement((String)SERVER, (String)serverName), PathElement.pathElement((String)"http-connector", (String)"http-connector")});
                addOp = Util.createEmptyOperation((String)"add", (PathAddress)pathAddress);
                addOp.get(SOCKET_BINDING).set("http");
                addOp.get(ENDPOINT).set("http-acceptor");
                server.executeManagementOperation(addOp);
                ServerMigrationLogger.ROOT_LOGGER.infof("HTTP Connector named %s added to Messaging ActiveMQ subsystem configuration.", (Object)"http-connector");
            }
        }
    }
}

