/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.wfly10.subsystem.remoting;

import java.io.IOException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.dmr.ModelNode;
import org.jboss.migration.core.ServerMigrationContext;
import org.jboss.migration.core.logger.ServerMigrationLogger;
import org.jboss.migration.wfly10.standalone.WildFly10StandaloneServer;
import org.jboss.migration.wfly10.subsystem.WildFly10Subsystem;
import org.jboss.migration.wfly10.subsystem.WildFly10SubsystemMigrationTask;

public class AddHttpConnectorIfMissing
implements WildFly10SubsystemMigrationTask {
    public static final AddHttpConnectorIfMissing INSTANCE = new AddHttpConnectorIfMissing();
    private static final String HTTP_CONNECTOR = "http-connector";
    private static final String HTTP_CONNECTOR_NAME = "http-remoting-connector";
    private static final String CONNECTOR_REF_ATTR_NAME = "connector-ref";
    private static final String CONNECTOR_REF_ATTR_VALUE = "http";
    private static final String SECURITY_REALM_ATTR_NAME = "security-realm";
    private static final String SECURITY_REALM_ATTR_VALUE = "ApplicationRealm";

    private AddHttpConnectorIfMissing() {
    }

    @Override
    public void execute(ModelNode config, WildFly10Subsystem subsystem, WildFly10StandaloneServer server, ServerMigrationContext context) throws IOException {
        if (config == null) {
            return;
        }
        PathElement subsystemPathElement = PathElement.pathElement((String)"subsystem", (String)subsystem.getName());
        if (!config.hasDefined(new String[]{HTTP_CONNECTOR, HTTP_CONNECTOR_NAME})) {
            PathAddress httpRemotingConnectorPathAddress = PathAddress.pathAddress((PathElement[])new PathElement[]{subsystemPathElement, PathElement.pathElement((String)HTTP_CONNECTOR, (String)HTTP_CONNECTOR_NAME)});
            ModelNode httpRemotingConnectorAddOp = Util.createEmptyOperation((String)"add", (PathAddress)httpRemotingConnectorPathAddress);
            httpRemotingConnectorAddOp.get(CONNECTOR_REF_ATTR_NAME).set(CONNECTOR_REF_ATTR_VALUE);
            httpRemotingConnectorAddOp.get(SECURITY_REALM_ATTR_NAME).set(SECURITY_REALM_ATTR_VALUE);
            server.executeManagementOperation(httpRemotingConnectorAddOp);
            ServerMigrationLogger.ROOT_LOGGER.infof("Http connector %s added to Remoting subsystem configuration.", (Object)HTTP_CONNECTOR_NAME);
        }
    }
}

