/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.wfly10.subsystem.undertow;

import java.io.IOException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.dmr.ModelNode;
import org.jboss.migration.core.ServerMigrationContext;
import org.jboss.migration.core.logger.ServerMigrationLogger;
import org.jboss.migration.wfly10.standalone.WildFly10StandaloneServer;
import org.jboss.migration.wfly10.subsystem.WildFly10Subsystem;
import org.jboss.migration.wfly10.subsystem.WildFly10SubsystemMigrationTask;

public class MigrateHttpListener
implements WildFly10SubsystemMigrationTask {
    private static final String SERVER = "server";
    private static final String SERVER_NAME = "default-server";
    private static final String HTTP_LISTENER = "http-listener";
    private static final String HTTP_LISTENER_NAME = "http";
    private static final String REDIRECT_SOCKET_ATTR_NAME = "redirect-socket";
    private static final String REDIRECT_SOCKET_ATTR_VALUE = "https";
    public static final MigrateHttpListener INSTANCE = new MigrateHttpListener();

    private MigrateHttpListener() {
    }

    @Override
    public void execute(ModelNode config, WildFly10Subsystem subsystem, WildFly10StandaloneServer server, ServerMigrationContext context) throws IOException {
        if (config == null) {
            return;
        }
        if (config.hasDefined(new String[]{SERVER, SERVER_NAME, HTTP_LISTENER, HTTP_LISTENER_NAME})) {
            PathAddress pathAddress = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"subsystem", (String)subsystem.getName()), PathElement.pathElement((String)SERVER, (String)SERVER_NAME), PathElement.pathElement((String)HTTP_LISTENER, (String)HTTP_LISTENER_NAME)});
            ModelNode op = Util.createEmptyOperation((String)"write-attribute", (PathAddress)pathAddress);
            op.get("name").set(REDIRECT_SOCKET_ATTR_NAME);
            op.get("value").set(REDIRECT_SOCKET_ATTR_VALUE);
            server.executeManagementOperation(op);
            ServerMigrationLogger.ROOT_LOGGER.infof("Undertow's default HTTP listener 'redirect-socket' set to 'https'.", new Object[0]);
        }
    }
}

