/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.wfly10.config.management.impl;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.dmr.ModelNode;
import org.jboss.migration.core.logger.ServerMigrationLogger;
import org.jboss.migration.wfly10.WildFly10Server;
import org.jboss.migration.wfly10.config.management.ManageableServerConfiguration;
import org.jboss.migration.wfly10.config.management.ManagementOperationException;

public abstract class AbstractManageableServerConfiguration
implements ManageableServerConfiguration {
    private final WildFly10Server server;
    private ModelControllerClient modelControllerClient;

    protected AbstractManageableServerConfiguration(WildFly10Server server) {
        this.server = server;
    }

    @Override
    public void start() {
        if (this.isStarted()) {
            throw new IllegalStateException("server started");
        }
        this.modelControllerClient = this.startConfiguration();
    }

    protected abstract ModelControllerClient startConfiguration();

    @Override
    public void stop() {
        if (!this.isStarted()) {
            throw new IllegalStateException("server not started");
        }
        this.stopConfiguration();
        this.modelControllerClient = null;
    }

    protected abstract void stopConfiguration();

    @Override
    public boolean isStarted() {
        return this.modelControllerClient != null;
    }

    @Override
    public WildFly10Server getServer() {
        return this.server;
    }

    protected void processResult(ModelNode result) throws ManagementOperationException {
        if (!"success".equals(result.get("outcome").asString())) {
            throw new ManagementOperationException(result.get("failure-description").asString());
        }
    }

    @Override
    public ModelNode executeManagementOperation(ModelNode operation) throws IOException {
        ModelControllerClient modelControllerClient = this.getModelControllerClient();
        if (modelControllerClient == null) {
            throw new IllegalStateException("configuration not started");
        }
        ModelNode result = modelControllerClient.execute(operation);
        this.processResult(result);
        return result;
    }

    @Override
    public Path resolvePath(String pathName) throws IOException {
        PathAddress address = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"path", (String)pathName)});
        ModelNode op = Util.createEmptyOperation((String)"read-resource", (PathAddress)address);
        ModelNode opResult = this.executeManagementOperation(op);
        ServerMigrationLogger.ROOT_LOGGER.debugf("Resolve path Op result %s", (Object)opResult.toString());
        String path = opResult.get("result").get("path").asString();
        if (!opResult.get("result").hasDefined("relative-to")) {
            return Paths.get(path, new String[0]);
        }
        return this.resolvePath(opResult.get("result").get("relative-to").asString()).resolve(path);
    }

    @Override
    public ModelControllerClient getModelControllerClient() {
        return this.modelControllerClient;
    }
}

