/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.wfly10.config.management.impl;

import java.io.IOException;
import java.util.Set;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.migration.wfly10.config.management.ExtensionsManagement;
import org.jboss.migration.wfly10.config.management.HostConfiguration;
import org.jboss.migration.wfly10.config.management.HostControllerConfiguration;
import org.jboss.migration.wfly10.config.management.InterfacesManagement;
import org.jboss.migration.wfly10.config.management.JVMsManagement;
import org.jboss.migration.wfly10.config.management.ManageableServerConfiguration;
import org.jboss.migration.wfly10.config.management.ManagementInterfacesManagement;
import org.jboss.migration.wfly10.config.management.SecurityRealmsManagement;
import org.jboss.migration.wfly10.config.management.SocketBindingGroupsManagement;
import org.jboss.migration.wfly10.config.management.SubsystemsManagement;
import org.jboss.migration.wfly10.config.management.impl.AbstractManageableServerConfiguration;
import org.jboss.migration.wfly10.config.management.impl.ExtensionsManagementImpl;
import org.jboss.migration.wfly10.config.management.impl.InterfacesManagementImpl;
import org.jboss.migration.wfly10.config.management.impl.JVMsManagementImpl;
import org.jboss.migration.wfly10.config.management.impl.ManagementInterfacesManagementImpl;
import org.jboss.migration.wfly10.config.management.impl.SecurityRealmsManagementImpl;
import org.jboss.migration.wfly10.config.management.impl.SocketBindingGroupsManagementImpl;
import org.jboss.migration.wfly10.config.management.impl.SubsystemsManagementImpl;
import org.jboss.migration.wfly10.config.task.HostMigration;

public class EmbeddedHostConfiguration
extends AbstractManageableServerConfiguration
implements HostConfiguration {
    private final String host;
    private final HostControllerConfiguration hostController;
    private final SubsystemsManagement subsystemsManagement;
    private final SecurityRealmsManagement securityRealmsManagement;
    private final ExtensionsManagement extensionsManagement;
    private final InterfacesManagement interfacesManagement;
    private final ManagementInterfacesManagement managementInterfacesManagement;
    private final JVMsManagement JVMsManagement;
    private final SocketBindingGroupsManagement socketBindingGroupsManagement;
    private final PathAddress hostPathAddress;

    public EmbeddedHostConfiguration(HostControllerConfiguration hostController, String host) {
        super(hostController.getServer());
        this.hostController = hostController;
        this.host = host;
        this.hostPathAddress = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"host", (String)host)});
        this.extensionsManagement = new ExtensionsManagementImpl(this.hostPathAddress, (ManageableServerConfiguration)this){

            @Override
            public Set<String> getSubsystems() throws IOException {
                return EmbeddedHostConfiguration.this.getSubsystemsManagement().getResourceNames();
            }
        };
        this.interfacesManagement = new InterfacesManagementImpl(this.hostPathAddress, this);
        this.subsystemsManagement = new SubsystemsManagementImpl(this.hostPathAddress, this);
        this.JVMsManagement = new JVMsManagementImpl(this.hostPathAddress, this);
        this.socketBindingGroupsManagement = new SocketBindingGroupsManagementImpl(this.hostPathAddress, this);
        PathAddress managementCoreServicePathAddress = this.hostPathAddress.append(new PathElement[]{PathElement.pathElement((String)"core-service", (String)"management")});
        this.securityRealmsManagement = new SecurityRealmsManagementImpl(managementCoreServicePathAddress, this);
        this.managementInterfacesManagement = new ManagementInterfacesManagementImpl(managementCoreServicePathAddress, this);
    }

    @Override
    protected ModelControllerClient startConfiguration() {
        return this.hostController.getModelControllerClient();
    }

    @Override
    protected void stopConfiguration() {
    }

    @Override
    public ExtensionsManagement getExtensionsManagement() {
        return this.extensionsManagement;
    }

    @Override
    public InterfacesManagement getInterfacesManagement() {
        return this.interfacesManagement;
    }

    @Override
    public SecurityRealmsManagement getSecurityRealmsManagement() {
        return this.securityRealmsManagement;
    }

    @Override
    public SubsystemsManagement getSubsystemsManagement() {
        return this.subsystemsManagement;
    }

    @Override
    public SocketBindingGroupsManagement getSocketBindingGroupsManagement() {
        return this.socketBindingGroupsManagement;
    }

    @Override
    public JVMsManagement getJVMsManagement() {
        return this.JVMsManagement;
    }

    @Override
    public ManagementInterfacesManagement getManagementInterfacesManagement() {
        return this.managementInterfacesManagement;
    }

    @Override
    public PathAddress getPathAddress() {
        return this.hostPathAddress;
    }

    public static class HostConfigFileMigrationFactory
    implements HostMigration.HostConfigurationProvider {
        @Override
        public EmbeddedHostConfiguration getHostConfiguration(String host, HostControllerConfiguration hostController) throws Exception {
            return new EmbeddedHostConfiguration(hostController, host);
        }
    }
}

