/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.wfly10.config.management.impl;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.dmr.ModelNode;
import org.jboss.migration.wfly10.config.management.ManageableServerConfiguration;
import org.jboss.migration.wfly10.config.management.ManagementOperationException;
import org.jboss.migration.wfly10.config.management.ResourcesManagement;

public class ResourcesManagementImpl
implements ResourcesManagement {
    private final ManageableServerConfiguration configurationManagement;
    private final PathAddress parentPathAddress;
    private final String type;

    public ResourcesManagementImpl(String type, PathAddress parentPathAddress, ManageableServerConfiguration configurationManagement) {
        this.type = type;
        this.parentPathAddress = parentPathAddress;
        this.configurationManagement = configurationManagement;
    }

    @Override
    public ManageableServerConfiguration getServerConfiguration() {
        return this.configurationManagement;
    }

    @Override
    public PathAddress getParentPathAddress() {
        return this.parentPathAddress;
    }

    @Override
    public String getResourceType() {
        return this.type;
    }

    protected PathAddress getPathAddress(PathElement ... elements) {
        PathAddress parentAddress = this.getParentPathAddress();
        return parentAddress != null ? parentAddress.append(elements) : PathAddress.pathAddress((PathElement[])elements);
    }

    @Override
    public PathAddress getResourcePathAddress(String resourceName) {
        return this.getPathAddress(PathElement.pathElement((String)this.type, (String)resourceName));
    }

    @Override
    public Set<String> getResourceNames() throws IOException {
        try {
            ModelNode op = Util.createEmptyOperation((String)"read-children-names", (PathAddress)this.getParentPathAddress());
            op.get("child-type").set(this.type);
            ModelNode opResult = this.configurationManagement.executeManagementOperation(op);
            HashSet<String> result = new HashSet<String>();
            for (ModelNode resultNode : opResult.get("result").asList()) {
                result.add(resultNode.asString());
            }
            return result;
        }
        catch (ManagementOperationException e) {
            try {
                ModelNode op = Util.createEmptyOperation((String)"read-children-types", (PathAddress)this.getParentPathAddress());
                ModelNode opResult = this.configurationManagement.executeManagementOperation(op);
                boolean childrenTypeFound = false;
                for (ModelNode resultNode : opResult.get("result").asList()) {
                    if (!this.type.equals(resultNode.asString())) continue;
                    childrenTypeFound = true;
                    break;
                }
                if (!childrenTypeFound) {
                    return Collections.emptySet();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw e;
        }
    }

    @Override
    public ModelNode getResource(String name) throws IOException {
        if (!this.getResourceNames().contains(name)) {
            return null;
        }
        PathAddress address = this.getResourcePathAddress(name);
        ModelNode op = Util.createEmptyOperation((String)"read-resource", (PathAddress)address);
        op.get("recursive").set(true);
        ModelNode result = this.configurationManagement.executeManagementOperation(op);
        return result.get("result");
    }

    @Override
    public void removeResource(String resourceName) throws IOException {
        PathAddress address = this.getResourcePathAddress(resourceName);
        ModelNode op = Util.createRemoveOperation((PathAddress)address);
        this.configurationManagement.executeManagementOperation(op);
    }
}

