/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.wfly10.config.task.factory;

import java.util.Collection;
import java.util.List;
import org.jboss.migration.core.ParentServerMigrationTask;
import org.jboss.migration.core.ServerMigrationTask;
import org.jboss.migration.core.ServerMigrationTaskName;
import org.jboss.migration.core.env.SkippableByEnvServerMigrationTask;
import org.jboss.migration.wfly10.config.management.ManageableServerConfiguration;
import org.jboss.migration.wfly10.config.task.ServerConfigurationMigration;
import org.jboss.migration.wfly10.config.task.factory.ManageableServerConfigurationTaskFactory;

public class ManageableServerConfigurationParentTaskFactory<S, T extends ManageableServerConfiguration>
implements ManageableServerConfigurationTaskFactory<S, T> {
    private final List<ManageableServerConfigurationTaskFactory<S, T>> subtaskFactories;
    private final ServerMigrationTaskName taskName;
    private String skipTaskPropertyName;
    private ParentServerMigrationTask.EventListener eventListener;

    protected ManageableServerConfigurationParentTaskFactory(Builder<S, T> builder) {
        this.subtaskFactories = ((Builder)builder).taskFactories.getFactories();
        this.taskName = ((Builder)builder).taskName;
        this.skipTaskPropertyName = ((Builder)builder).skipTaskPropertyName;
        this.eventListener = ((Builder)builder).eventListener;
    }

    @Override
    public ServerMigrationTask getTask(S source, T configuration) throws Exception {
        ParentServerMigrationTask.Builder taskBuilder = new ParentServerMigrationTask.Builder(this.taskName).succeedOnlyIfHasSuccessfulSubtasks();
        if (this.eventListener != null) {
            taskBuilder.eventListener(this.eventListener);
        }
        for (ManageableServerConfigurationTaskFactory<S, T> subtaskFactory : this.subtaskFactories) {
            taskBuilder.subtask(subtaskFactory.getTask(source, configuration));
        }
        ParentServerMigrationTask task = taskBuilder.build();
        if (this.skipTaskPropertyName != null) {
            task = new SkippableByEnvServerMigrationTask((ServerMigrationTask)task, this.skipTaskPropertyName);
        }
        return task;
    }

    public static class Builder<S, T extends ManageableServerConfiguration> {
        private final ServerConfigurationMigration.ManageableServerConfigurationTaskFactories<S, T> taskFactories;
        private final ServerMigrationTaskName taskName;
        private String skipTaskPropertyName;
        private ParentServerMigrationTask.EventListener eventListener;

        public Builder(ServerMigrationTaskName taskName) {
            this.taskName = taskName;
            this.taskFactories = new ServerConfigurationMigration.ManageableServerConfigurationTaskFactories();
        }

        public Builder<S, T> subtask(ManageableServerConfigurationTaskFactory<S, T> subtaskFactory) {
            this.taskFactories.add(subtaskFactory);
            return this;
        }

        public Builder<S, T> subtasks(Collection<ManageableServerConfigurationTaskFactory<S, T>> subtaskFactories) {
            this.taskFactories.addAll(subtaskFactories);
            return this;
        }

        public Builder<S, T> eventListener(ParentServerMigrationTask.EventListener eventListener) {
            this.eventListener = eventListener;
            return this;
        }

        public Builder<S, T> skipTaskPropertyName(String skipTaskPropertyName) {
            this.skipTaskPropertyName = skipTaskPropertyName;
            return this;
        }

        public ManageableServerConfigurationParentTaskFactory<S, T> build() {
            return new ManageableServerConfigurationParentTaskFactory(this);
        }
    }
}

