/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.wfly10.config.task.subsystem;

import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.dmr.ModelNode;
import org.jboss.migration.core.ServerMigrationTask;
import org.jboss.migration.core.ServerMigrationTaskContext;
import org.jboss.migration.core.ServerMigrationTaskName;
import org.jboss.migration.core.ServerMigrationTaskResult;
import org.jboss.migration.core.env.TaskEnvironment;
import org.jboss.migration.wfly10.config.management.ExtensionsManagement;
import org.jboss.migration.wfly10.config.management.SubsystemsManagement;
import org.jboss.migration.wfly10.config.task.subsystem.WildFly10Subsystem;
import org.jboss.migration.wfly10.config.task.subsystem.WildFly10SubsystemMigrationTask;
import org.jboss.migration.wfly10.config.task.subsystem.WildFly10SubsystemMigrationTaskFactory;

public class AddExtension
implements WildFly10SubsystemMigrationTaskFactory {
    public static final AddExtension INSTANCE = new AddExtension();

    private AddExtension() {
    }

    @Override
    public ServerMigrationTask getServerMigrationTask(ModelNode config, final WildFly10Subsystem subsystem, SubsystemsManagement subsystemsManagement) {
        return new WildFly10SubsystemMigrationTask(config, subsystem, subsystemsManagement){
            private final ServerMigrationTaskName taskName;
            {
                super(config, subsystem2, subsystemsManagement);
                this.taskName = new ServerMigrationTaskName.Builder("add-extension").addAttribute("name", subsystem.getExtension().getName()).build();
            }

            public ServerMigrationTaskName getName() {
                return this.taskName;
            }

            @Override
            protected ServerMigrationTaskResult run(ModelNode config, WildFly10Subsystem subsystem2, SubsystemsManagement subsystemsManagement, ServerMigrationTaskContext context, TaskEnvironment taskEnvironment) throws Exception {
                String extensionName = subsystem2.getExtension().getName();
                ExtensionsManagement extensionsManagement = subsystemsManagement.getServerConfiguration().getExtensionsManagement();
                if (!extensionsManagement.getResourceNames().contains(extensionName)) {
                    context.getLogger().debugf("Adding Extension %s...", (Object)extensionName);
                    ModelNode op = Util.createAddOperation((PathAddress)extensionsManagement.getResourcePathAddress(extensionName));
                    op.get("module").set(extensionName);
                    subsystemsManagement.getServerConfiguration().executeManagementOperation(op);
                    context.getLogger().infof("Extension %s added.", (Object)extensionName);
                    return ServerMigrationTaskResult.SUCCESS;
                }
                context.getLogger().infof("Skipped adding extension %s, already exists in config.", (Object)extensionName);
                return ServerMigrationTaskResult.SKIPPED;
            }
        };
    }
}

