/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.wfly10.config.task.subsystem;

import org.jboss.migration.core.ParentServerMigrationTask;
import org.jboss.migration.core.ServerMigrationTask;
import org.jboss.migration.core.ServerMigrationTaskName;
import org.jboss.migration.core.env.SkippableByEnvServerMigrationTask;
import org.jboss.migration.wfly10.config.management.HostConfiguration;
import org.jboss.migration.wfly10.config.management.HostControllerConfiguration;
import org.jboss.migration.wfly10.config.management.ManageableServerConfiguration;
import org.jboss.migration.wfly10.config.management.StandaloneServerConfiguration;
import org.jboss.migration.wfly10.config.task.executor.SubtaskExecutorAdapters;
import org.jboss.migration.wfly10.config.task.factory.DomainConfigurationTaskFactory;
import org.jboss.migration.wfly10.config.task.factory.HostConfigurationTaskFactory;
import org.jboss.migration.wfly10.config.task.factory.StandaloneServerConfigurationTaskFactory;
import org.jboss.migration.wfly10.config.task.subsystem.AddExtensionSubtask;
import org.jboss.migration.wfly10.config.task.subsystem.AddSubsystemConfigSubtask;

public class AddSubsystemTaskFactory<S>
implements StandaloneServerConfigurationTaskFactory<S>,
HostConfigurationTaskFactory<S>,
DomainConfigurationTaskFactory<S> {
    private final ServerMigrationTaskName taskName;
    private final AddExtensionSubtask<S> addExtensionSubtask;
    private final AddSubsystemConfigSubtask<S> addSubsystemConfigSubtask;
    private String skipTaskPropertyName;
    private ParentServerMigrationTask.EventListener eventListener;

    protected AddSubsystemTaskFactory(Builder<S> builder) {
        this.taskName = ((Builder)builder).taskName != null ? ((Builder)builder).taskName : new ServerMigrationTaskName.Builder("add-subsystem").addAttribute("name", ((Builder)builder).subsystemName).build();
        this.addExtensionSubtask = new AddExtensionSubtask(((Builder)builder).extensionName);
        this.addSubsystemConfigSubtask = ((Builder)builder).addSubsystemConfigSubtask != null ? ((Builder)builder).addSubsystemConfigSubtask : new AddSubsystemConfigSubtask(((Builder)builder).subsystemName);
        this.skipTaskPropertyName = ((Builder)builder).skipTaskPropertyName != null ? ((Builder)builder).skipTaskPropertyName : this.taskName.getName() + ".skip";
        this.eventListener = ((Builder)builder).eventListener;
    }

    @Override
    public ServerMigrationTask getTask(S source, HostConfiguration configuration) throws Exception {
        return this.getTask(source, SubtaskExecutorAdapters.of(source, (ManageableServerConfiguration)configuration, this.addExtensionSubtask), SubtaskExecutorAdapters.of(source, configuration, this.addSubsystemConfigSubtask));
    }

    @Override
    public ServerMigrationTask getTask(S source, HostControllerConfiguration configuration) throws Exception {
        return this.getTask(source, SubtaskExecutorAdapters.of(source, (ManageableServerConfiguration)configuration, this.addExtensionSubtask), SubtaskExecutorAdapters.of(source, configuration, this.addSubsystemConfigSubtask));
    }

    @Override
    public ServerMigrationTask getTask(S source, StandaloneServerConfiguration configuration) throws Exception {
        return this.getTask(source, SubtaskExecutorAdapters.of(source, (ManageableServerConfiguration)configuration, this.addExtensionSubtask), SubtaskExecutorAdapters.of(source, configuration, this.addSubsystemConfigSubtask));
    }

    private ServerMigrationTask getTask(S source, ParentServerMigrationTask.SubtaskExecutor addExtensionSubtask, ParentServerMigrationTask.SubtaskExecutor addSubsystemSubtask) throws Exception {
        ParentServerMigrationTask.Builder taskBuilder = new ParentServerMigrationTask.Builder(this.taskName).subtask(addExtensionSubtask).subtask(addSubsystemSubtask);
        if (this.eventListener != null) {
            taskBuilder.eventListener(this.eventListener);
        }
        return new SkippableByEnvServerMigrationTask((ServerMigrationTask)taskBuilder.build(), this.skipTaskPropertyName);
    }

    public static class Builder<S> {
        private ServerMigrationTaskName taskName;
        private final String subsystemName;
        private final String extensionName;
        private AddSubsystemConfigSubtask<S> addSubsystemConfigSubtask;
        private String skipTaskPropertyName;
        private ParentServerMigrationTask.EventListener eventListener;

        public Builder(String subsystemName, String extensionName) {
            this.subsystemName = subsystemName;
            this.extensionName = extensionName;
        }

        public Builder<S> eventListener(ParentServerMigrationTask.EventListener eventListener) {
            this.eventListener = eventListener;
            return this;
        }

        public Builder<S> skipTaskPropertyName(String skipTaskPropertyName) {
            this.skipTaskPropertyName = skipTaskPropertyName;
            return this;
        }

        public Builder<S> subtask(AddSubsystemConfigSubtask<S> subtask) {
            this.addSubsystemConfigSubtask = subtask;
            return this;
        }

        public Builder<S> taskName(ServerMigrationTaskName taskName) {
            this.taskName = taskName;
            return this;
        }

        public AddSubsystemTaskFactory<S> build() {
            return new AddSubsystemTaskFactory(this);
        }
    }
}

